/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.declaration.ExtendsMatch;
import org.revapi.classif.match.declaration.ImplementsMatch;
import org.revapi.classif.match.declaration.UsedByMatch;
import org.revapi.classif.match.declaration.UsesMatch;
import org.revapi.classif.progress.context.MatchContext;

public final class TypeConstraintsMatch
extends DeclarationMatch {
    private final List<ImplementsMatch> implemented;
    private final ExtendsMatch extended;
    private final List<UsesMatch> uses;
    private final List<UsedByMatch> usedBys;

    public TypeConstraintsMatch(List<ImplementsMatch> implemented, ExtendsMatch extended, List<UsesMatch> uses, List<UsedByMatch> usedBys) {
        this.implemented = implemented;
        this.extended = extended;
        this.uses = uses;
        this.usedBys = usedBys;
    }

    @Override
    public <M> TestResult testAnyDeclaration(Element declaration, TypeMirror instantiation, MatchContext<M> ctx) {
        return TestResult.TestableStream.testable(this.implemented).testAll(m -> m.testDeclaration(declaration, instantiation, ctx)).and(() -> TestResult.TestableStream.testable(this.uses).testAll(m -> m.testDeclaration(declaration, instantiation, ctx))).and(() -> TestResult.TestableStream.testable(this.usedBys).testAll(m -> m.testDeclaration(declaration, instantiation, ctx))).and(() -> this.extended == null ? TestResult.PASSED : this.extended.testDeclaration(declaration, instantiation, ctx));
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        if (this.extended != null) {
            bld.append(this.extended);
        }
        if (bld.length() > 0 && !this.implemented.isEmpty()) {
            bld.append(" ");
        }
        bld.append(this.implemented.stream().map(Object::toString).collect(Collectors.joining(" ")));
        if (bld.length() > 0 && !this.uses.isEmpty()) {
            bld.append(" ");
        }
        bld.append(this.uses.stream().map(Object::toString).collect(Collectors.joining(" ")));
        if (bld.length() > 0 && !this.usedBys.isEmpty()) {
            bld.append(" ");
        }
        bld.append(this.usedBys.stream().map(Object::toString).collect(Collectors.joining(" ")));
        return bld.toString();
    }
}

