/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import org.revapi.API;
import org.revapi.Archive;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.AbstractJavaElement;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.spi.JavaAnnotationElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.Util;

public final class AnnotationElement
extends AbstractJavaElement
implements JavaAnnotationElement {
    private final AnnotationMirror annotation;
    private String comparableSignature;

    public AnnotationElement(ProbingEnvironment environment, Archive archive, AnnotationMirror annotation) {
        super(environment);
        this.annotation = annotation;
        this.setArchive(archive);
    }

    @Override
    @Nonnull
    public JavaModelElement getParent() {
        return (JavaModelElement)super.getParent();
    }

    @Nonnull
    public API getApi() {
        return this.environment.getApi();
    }

    @Override
    @Nonnull
    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    @Override
    @Nonnull
    public TypeEnvironment getTypeEnvironment() {
        return this.environment;
    }

    public int compareTo(@Nonnull JavaElement o) {
        if (!(o instanceof AnnotationElement)) {
            return JavaElementFactory.compareByType(this, o);
        }
        return this.getComparableSignature().compareTo(((AnnotationElement)o).getComparableSignature());
    }

    @Nonnull
    public String getFullHumanReadableString() {
        return Util.toHumanReadableString(this.annotation);
    }

    public String toString() {
        return this.getFullHumanReadableString();
    }

    public AnnotationElement clone() {
        return (AnnotationElement)super.clone();
    }

    private String getComparableSignature() {
        if (this.comparableSignature == null) {
            this.comparableSignature = "@" + Util.toHumanReadableString(this.annotation.getAnnotationType());
        }
        return this.comparableSignature;
    }
}

