/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.lang.model.util.SimpleTypeVisitor7;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.revapi.java.spi.IgnoreCompletionFailures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static SimpleTypeVisitor8<Name, Void> getTypeVariableName = new SimpleTypeVisitor8<Name, Void>(){

        @Override
        protected Name defaultAction(TypeMirror e, Void ignore) {
            return null;
        }

        @Override
        public Name visitTypeVariable(TypeVariable t, Void ignored) {
            return t.asElement().getSimpleName();
        }
    };
    private static SimpleTypeVisitor8<Boolean, Void> isJavaLangObject = new SimpleTypeVisitor8<Boolean, Void>(){

        @Override
        protected Boolean defaultAction(TypeMirror e, Void aVoid) {
            return false;
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void aVoid) {
            Element el = t.asElement();
            if (el instanceof TypeElement) {
                return ((TypeElement)el).getQualifiedName().contentEquals("java.lang.Object");
            }
            return false;
        }
    };
    private static SimpleTypeVisitor7<Void, StringBuilderAndState<TypeMirror>> toUniqueStringVisitor = new SimpleTypeVisitor8<Void, StringBuilderAndState<TypeMirror>>(){

        @Override
        public Void visitPrimitive(PrimitiveType t, StringBuilderAndState<TypeMirror> state) {
            switch (t.getKind()) {
                case BOOLEAN: {
                    state.bld.append("boolean");
                    break;
                }
                case BYTE: {
                    state.bld.append("byte");
                    break;
                }
                case CHAR: {
                    state.bld.append("char");
                    break;
                }
                case DOUBLE: {
                    state.bld.append("double");
                    break;
                }
                case FLOAT: {
                    state.bld.append("float");
                    break;
                }
                case INT: {
                    state.bld.append("int");
                    break;
                }
                case LONG: {
                    state.bld.append("long");
                    break;
                }
                case SHORT: {
                    state.bld.append("short");
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitArray(ArrayType t, StringBuilderAndState<TypeMirror> bld) {
            IgnoreCompletionFailures.in(t::getComponentType).accept(this, bld);
            bld.bld.append("[]");
            return null;
        }

        @Override
        public Void visitIntersection(IntersectionType t, StringBuilderAndState<TypeMirror> state) {
            List bounds = IgnoreCompletionFailures.in(t::getBounds);
            if (state.visitingMethod) {
                if (!bounds.isEmpty()) {
                    ((TypeMirror)bounds.get(0)).accept(this, state);
                }
            } else {
                for (TypeMirror b : bounds) {
                    b.accept(this, state);
                    state.bld.append("+");
                }
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, StringBuilderAndState<TypeMirror> state) {
            if (state.visitingMethod) {
                TypeMirror upperBound = IgnoreCompletionFailures.in(t::getUpperBound);
                upperBound.accept(this, state);
                return null;
            }
            if (state.visitedObjects.contains(t)) {
                state.bld.append("%");
                return null;
            }
            state.visitedObjects.add(t);
            TypeMirror lowerBound = IgnoreCompletionFailures.in(t::getLowerBound);
            if (lowerBound != null && lowerBound.getKind() != TypeKind.NULL) {
                lowerBound.accept(this, state);
                state.bld.append("-");
            }
            IgnoreCompletionFailures.in(t::getUpperBound).accept(this, state);
            state.bld.append("+");
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t, StringBuilderAndState<TypeMirror> state) {
            TypeMirror extendsBound = IgnoreCompletionFailures.in(t::getExtendsBound);
            if (state.visitingMethod) {
                if (extendsBound != null) {
                    extendsBound.accept(this, state);
                } else {
                    state.bld.append("java.lang.Object");
                }
                return null;
            }
            TypeMirror superBound = IgnoreCompletionFailures.in(t::getSuperBound);
            if (superBound != null) {
                superBound.accept(this, state);
                state.bld.append("-");
            }
            if (extendsBound != null) {
                extendsBound.accept(this, state);
                state.bld.append("+");
            } else {
                state.bld.append("java.lang.Object+");
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableType t, StringBuilderAndState<TypeMirror> state) {
            state.bld.append("(");
            state.visitingMethod = true;
            Iterator it = IgnoreCompletionFailures.in(t::getParameterTypes).iterator();
            if (it.hasNext()) {
                ((TypeMirror)it.next()).accept(this, state);
            }
            while (it.hasNext()) {
                state.bld.append(",");
                ((TypeMirror)it.next()).accept(this, state);
            }
            state.bld.append(")");
            state.visitingMethod = false;
            return null;
        }

        @Override
        public Void visitNoType(NoType t, StringBuilderAndState<TypeMirror> state) {
            switch (t.getKind()) {
                case VOID: {
                    state.bld.append("void");
                    break;
                }
                case PACKAGE: {
                    state.bld.append("package");
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitDeclared(DeclaredType t, StringBuilderAndState<TypeMirror> state) {
            Name name = ((TypeElement)t.asElement()).getQualifiedName();
            state.bld.append(name);
            if (!state.visitingMethod) {
                this.visitTypeVars(IgnoreCompletionFailures.in(t::getTypeArguments), state);
            }
            return null;
        }

        @Override
        public Void visitError(ErrorType t, StringBuilderAndState<TypeMirror> state) {
            state.bld.append(((TypeElement)t.asElement()).getQualifiedName());
            return null;
        }

        private void visitTypeVars(List<? extends TypeMirror> vars, StringBuilderAndState<TypeMirror> state) {
            if (!vars.isEmpty()) {
                state.bld.append("<");
                Iterator<? extends TypeMirror> it = vars.iterator();
                it.next().accept(this, state);
                while (it.hasNext()) {
                    state.bld.append(",");
                    it.next().accept(this, state);
                }
                state.bld.append(">");
            }
        }
    };
    private static SimpleTypeVisitor7<Void, StringBuilderAndState<TypeMirror>> toHumanReadableStringVisitor = new DepthTrackingVisitor<Void, TypeMirror>(){

        @Override
        protected Void doVisitPrimitive(PrimitiveType t, StringBuilderAndState<TypeMirror> state) {
            switch (t.getKind()) {
                case BOOLEAN: {
                    state.bld.append("boolean");
                    break;
                }
                case BYTE: {
                    state.bld.append("byte");
                    break;
                }
                case CHAR: {
                    state.bld.append("char");
                    break;
                }
                case DOUBLE: {
                    state.bld.append("double");
                    break;
                }
                case FLOAT: {
                    state.bld.append("float");
                    break;
                }
                case INT: {
                    state.bld.append("int");
                    break;
                }
                case LONG: {
                    state.bld.append("long");
                    break;
                }
                case SHORT: {
                    state.bld.append("short");
                    break;
                }
            }
            return null;
        }

        @Override
        protected Void doVisitArray(ArrayType t, StringBuilderAndState<TypeMirror> state) {
            IgnoreCompletionFailures.in(t::getComponentType).accept(this, state);
            state.bld.append("[]");
            return null;
        }

        @Override
        protected Void doVisitTypeVariable(TypeVariable t, StringBuilderAndState<TypeMirror> state) {
            Name tName = t.asElement().getSimpleName();
            if (state.depth > state.anticipatedTypeVarDeclDepth && state.forwardTypeVarDecls.contains(tName)) {
                state.bld.append(tName);
                return null;
            }
            state.bld.append(tName);
            TypeMirror lowerBound = IgnoreCompletionFailures.in(t::getLowerBound);
            if (lowerBound != null && lowerBound.getKind() != TypeKind.NULL) {
                state.bld.append(" super ");
                lowerBound.accept(this, state);
            }
            TypeMirror upperBound = IgnoreCompletionFailures.in(t::getUpperBound);
            if (!((Boolean)isJavaLangObject.visit(upperBound)).booleanValue()) {
                state.bld.append(" extends ");
                upperBound.accept(this, state);
            }
            return null;
        }

        @Override
        protected Void doVisitWildcard(WildcardType t, StringBuilderAndState<TypeMirror> state) {
            state.bld.append("?");
            TypeMirror superBound = IgnoreCompletionFailures.in(t::getSuperBound);
            if (superBound != null) {
                state.bld.append(" super ");
                superBound.accept(this, state);
            }
            TypeMirror extendsBound = IgnoreCompletionFailures.in(t::getExtendsBound);
            if (extendsBound != null) {
                state.bld.append(" extends ");
                extendsBound.accept(this, state);
            }
            return null;
        }

        @Override
        protected Void doVisitExecutable(ExecutableType t, StringBuilderAndState<TypeMirror> state) {
            Runnable methodNameRenderer = null;
            if (state.methodInitAndNameOutput != null) {
                methodNameRenderer = state.methodInitAndNameOutput.apply(state);
            }
            int currentTypeDeclDepth = state.anticipatedTypeVarDeclDepth;
            state.anticipatedTypeVarDeclDepth = state.depth + 1;
            List typeVars = IgnoreCompletionFailures.in(t::getTypeVariables);
            this.visitTypeVars(typeVars, state);
            List typeVarNames = typeVars.stream().map(v -> v.asElement().getSimpleName()).filter(v -> !state.forwardTypeVarDecls.contains(v)).collect(Collectors.toList());
            state.forwardTypeVarDecls.addAll(typeVarNames);
            state.anticipatedTypeVarDeclDepth = currentTypeDeclDepth;
            state.visitingMethod = true;
            if (!typeVars.isEmpty()) {
                state.bld.append(" ");
            }
            currentTypeDeclDepth = state.anticipatedTypeVarDeclDepth;
            state.anticipatedTypeVarDeclDepth = state.depth;
            IgnoreCompletionFailures.in(t::getReturnType).accept(this, state);
            state.bld.append(" ");
            if (methodNameRenderer != null) {
                methodNameRenderer.run();
            }
            state.bld.append("(");
            Iterator it = IgnoreCompletionFailures.in(t::getParameterTypes).iterator();
            if (it.hasNext()) {
                ((TypeMirror)it.next()).accept(this, state);
            }
            while (it.hasNext()) {
                state.bld.append(", ");
                ((TypeMirror)it.next()).accept(this, state);
            }
            state.bld.append(")");
            List thrownTypes = IgnoreCompletionFailures.in(t::getThrownTypes);
            if (!thrownTypes.isEmpty()) {
                state.bld.append(" throws ");
                it = thrownTypes.iterator();
                ((TypeMirror)it.next()).accept(this, state);
                while (it.hasNext()) {
                    state.bld.append(", ");
                    ((TypeMirror)it.next()).accept(this, state);
                }
            }
            state.visitingMethod = false;
            state.forwardTypeVarDecls.removeAll(typeVarNames);
            state.anticipatedTypeVarDeclDepth = currentTypeDeclDepth;
            return null;
        }

        @Override
        protected Void doVisitNoType(NoType t, StringBuilderAndState<TypeMirror> state) {
            switch (t.getKind()) {
                case VOID: {
                    state.bld.append("void");
                    break;
                }
                case PACKAGE: {
                    state.bld.append("package");
                    break;
                }
            }
            return null;
        }

        @Override
        protected Void doVisitDeclared(DeclaredType t, StringBuilderAndState<TypeMirror> state) {
            CharSequence name;
            int anticipatedTypeVarDeclDepth = state.anticipatedTypeVarDeclDepth;
            int depth = state.depth--;
            if (t.getEnclosingType().getKind() != TypeKind.NONE) {
                this.visit(t.getEnclosingType(), state);
                state.depth = depth;
                state.anticipatedTypeVarDeclDepth = anticipatedTypeVarDeclDepth;
                ((DeclaredType)t.getEnclosingType()).getTypeArguments().forEach(a -> state.forwardTypeVarDecls.add((Name)getTypeVariableName.visit((TypeMirror)a)));
                name = "." + t.asElement().getSimpleName();
            } else {
                name = ((TypeElement)t.asElement()).getQualifiedName();
            }
            state.bld.append(name);
            try {
                if (state.depth == 1) {
                    state.anticipatedTypeVarDeclDepth = 2;
                }
                this.visitTypeVars(IgnoreCompletionFailures.in(t::getTypeArguments), state);
                state.anticipatedTypeVarDeclDepth = anticipatedTypeVarDeclDepth;
            }
            catch (RuntimeException e) {
                LOG.error("Failed to enumerate type arguments of '" + name + "'. Class is missing?", (Throwable)e);
            }
            return null;
        }

        @Override
        protected Void doVisitIntersection(IntersectionType t, StringBuilderAndState<TypeMirror> state) {
            Iterator<TypeMirror> it = IgnoreCompletionFailures.in(t::getBounds).iterator();
            if (it.hasNext()) {
                ((TypeMirror)it.next()).accept(this, state);
            }
            4 me = this;
            it.forEachRemaining(b -> {
                state.bld.append(" & ");
                b.accept(me, state);
            });
            return null;
        }

        @Override
        protected Void doVisitError(ErrorType t, StringBuilderAndState<TypeMirror> state) {
            state.bld.append(((TypeElement)t.asElement()).getQualifiedName());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean visitTypeVars(List<? extends TypeMirror> vars, StringBuilderAndState<TypeMirror> state) {
            if (!vars.isEmpty()) {
                Set names = vars.stream().map(v -> (Name)getTypeVariableName.visit((TypeMirror)v)).collect(Collectors.toSet());
                names.removeAll(state.forwardTypeVarDecls);
                state.forwardTypeVarDecls.addAll(names);
                try {
                    state.bld.append("<");
                    Iterator<? extends TypeMirror> it = vars.iterator();
                    it.next().accept(this, state);
                    while (it.hasNext()) {
                        state.bld.append(", ");
                        it.next().accept(this, state);
                    }
                    state.bld.append(">");
                }
                finally {
                    state.forwardTypeVarDecls.removeAll(names);
                }
                return true;
            }
            return false;
        }
    };
    private static SimpleElementVisitor7<Void, StringBuilderAndState<TypeMirror>> toHumanReadableStringElementVisitor = new SimpleElementVisitor7<Void, StringBuilderAndState<TypeMirror>>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Void visitVariable(VariableElement e, StringBuilderAndState<TypeMirror> state) {
            Element enclosing = e.getEnclosingElement();
            if (enclosing instanceof TypeElement) {
                enclosing.accept(this, state);
                state.bld.append(".").append(e.getSimpleName());
                return null;
            }
            if (!(enclosing instanceof ExecutableElement)) return null;
            int paramIdx = ((ExecutableElement)enclosing).getParameters().indexOf(e);
            enclosing.accept(this, state);
            int openPar = state.bld.indexOf("(");
            int closePar = state.bld.indexOf(")", openPar);
            int paramStart = openPar + 1;
            int curParIdx = -1;
            int parsingState = 0;
            int typeParamDepth = 0;
            int i = openPar + 1;
            while (true) {
                if (i >= closePar) {
                    if (++curParIdx != paramIdx) return null;
                    String par = state.bld.substring(paramStart, closePar);
                    state.bld.replace(paramStart, closePar, "===" + par + "===");
                    return null;
                }
                char c = state.bld.charAt(i);
                switch (parsingState) {
                    case 0: {
                        switch (c) {
                            case ',': {
                                if (++curParIdx == paramIdx) {
                                    String par = state.bld.substring(paramStart, i);
                                    state.bld.replace(paramStart, i, "===" + par + "===");
                                    break;
                                }
                                paramStart = i + (paramIdx == 0 ? 1 : 2);
                                break;
                            }
                            case '<': {
                                parsingState = 1;
                                typeParamDepth = 1;
                                break;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (c) {
                            case '<': {
                                ++typeParamDepth;
                                break;
                            }
                            case '>': {
                                if (--typeParamDepth != 0) break;
                                parsingState = 0;
                            }
                        }
                        break;
                    }
                }
                ++i;
            }
        }

        @Override
        public Void visitPackage(PackageElement e, StringBuilderAndState<TypeMirror> state) {
            state.bld.append(e.getQualifiedName());
            return null;
        }

        @Override
        public Void visitType(TypeElement e, StringBuilderAndState<TypeMirror> state) {
            return (Void)e.asType().accept(toHumanReadableStringVisitor, state);
        }

        @Override
        public Void visitExecutable(ExecutableElement e, StringBuilderAndState<TypeMirror> state) {
            state.methodInitAndNameOutput = st -> {
                Element parent = e.getEnclosingElement();
                ArrayList names = new ArrayList(4);
                while (parent instanceof TypeElement) {
                    TypeElement type = (TypeElement)parent;
                    type.getTypeParameters().stream().map(p -> (Name)getTypeVariableName.visit(p.asType())).forEach(names::add);
                    parent = parent.getEnclosingElement();
                }
                st.forwardTypeVarDecls.addAll(names);
                return () -> {
                    int depth = st.depth;
                    try {
                        st.depth = 0;
                        e.getEnclosingElement().accept(this, st);
                        st.forwardTypeVarDecls.addAll(names);
                        st.bld.append("::").append(e.getSimpleName());
                    }
                    finally {
                        st.depth = depth;
                    }
                };
            };
            e.asType().accept(toHumanReadableStringVisitor, state);
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, StringBuilderAndState<TypeMirror> state) {
            return (Void)e.asType().accept(toHumanReadableStringVisitor, state);
        }
    };
    private static final SimpleAnnotationValueVisitor7<String, Void> annotationValueVisitor = new SimpleAnnotationValueVisitor7<String, Void>(){

        @Override
        protected String defaultAction(Object o, Void ignored) {
            if (o instanceof String) {
                return "\"" + o.toString() + "\"";
            }
            if (o instanceof Character) {
                return "'" + o.toString() + "'";
            }
            return o.toString();
        }

        @Override
        public String visitType(TypeMirror t, Void ignored) {
            return Util.toHumanReadableString(t) + ".class";
        }

        @Override
        public String visitEnumConstant(VariableElement c, Void ignored) {
            return Util.toHumanReadableString(c.asType()) + "." + c.getSimpleName().toString();
        }

        @Override
        public String visitAnnotation(AnnotationMirror a, Void ignored) {
            StringBuilder bld = new StringBuilder("@").append(Util.toHumanReadableString(a.getAnnotationType()));
            Map<? extends ExecutableElement, ? extends AnnotationValue> attributes = a.getElementValues();
            if (!attributes.isEmpty()) {
                bld.append("(");
                boolean single = attributes.size() == 1;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : attributes.entrySet()) {
                    String name = e.getKey().getSimpleName().toString();
                    if (single && "value".equals(name)) {
                        bld.append(e.getValue().accept(this, null));
                    } else {
                        bld.append(name).append(" = ");
                        bld.append(e.getValue().accept(this, null));
                    }
                    bld.append(", ");
                }
                bld.replace(bld.length() - 2, bld.length(), "");
                bld.append(")");
            }
            return bld.toString();
        }

        @Override
        public String visitArray(List<? extends AnnotationValue> vals, Void ignored) {
            StringBuilder bld = new StringBuilder("{");
            Iterator<? extends AnnotationValue> it = vals.iterator();
            if (it.hasNext()) {
                bld.append(it.next().accept(this, null));
            }
            while (it.hasNext()) {
                bld.append(", ").append(it.next().accept(this, null));
            }
            bld.append("}");
            return bld.toString();
        }
    };

    private Util() {
    }

    public static boolean isSameType(@Nonnull TypeMirror t1, @Nonnull TypeMirror t2) {
        String t1Name = Util.toUniqueString(t1);
        String t2Name = Util.toUniqueString(t2);
        return t1Name.equals(t2Name);
    }

    @Nonnull
    public static String toHumanReadableString(@Nonnull AnnotatedConstruct construct) {
        StringBuilderAndState state = new StringBuilderAndState();
        if (construct instanceof Element) {
            ((Element)construct).accept(toHumanReadableStringElementVisitor, state);
        } else if (construct instanceof TypeMirror) {
            ((TypeMirror)construct).accept(toHumanReadableStringVisitor, state);
        }
        return state.bld.toString();
    }

    @Nonnull
    public static String toUniqueString(@Nonnull TypeMirror t) {
        StringBuilderAndState state = new StringBuilderAndState();
        t.accept(toUniqueStringVisitor, state);
        return state.bld.toString();
    }

    @Nonnull
    public static String toUniqueString(@Nonnull AnnotationValue v) {
        return Util.toHumanReadableString(v);
    }

    @Nonnull
    public static String toHumanReadableString(@Nonnull AnnotationValue v) {
        return v.accept(annotationValueVisitor, null);
    }

    @Nonnull
    public static String toHumanReadableString(@Nonnull AnnotationMirror v) {
        return (String)annotationValueVisitor.visitAnnotation(v, null);
    }

    @Nonnull
    public static List<TypeMirror> getAllSuperClasses(@Nonnull Types types, @Nonnull TypeMirror type) {
        ArrayList<TypeMirror> ret = new ArrayList<TypeMirror>();
        try {
            List<? extends TypeMirror> superTypes = types.directSupertypes(type);
            while (superTypes != null && !superTypes.isEmpty()) {
                TypeMirror superClass = superTypes.get(0);
                ret.add(superClass);
                superTypes = types.directSupertypes(superClass);
            }
        }
        catch (RuntimeException e) {
            LOG.debug("Failed to find all super classes of type '" + Util.toHumanReadableString(type) + ". Possibly missing classes?", (Throwable)e);
        }
        return ret;
    }

    @Nonnull
    public static List<TypeMirror> getAllSuperTypes(@Nonnull Types types, @Nonnull TypeMirror type) {
        ArrayList<TypeMirror> ret = new ArrayList<TypeMirror>();
        Util.fillAllSuperTypes(types, type, ret);
        return ret;
    }

    public static void fillAllSuperTypes(@Nonnull Types types, @Nonnull TypeMirror type, @Nonnull List<TypeMirror> result) {
        try {
            List<? extends TypeMirror> superTypes = types.directSupertypes(type);
            for (TypeMirror typeMirror : superTypes) {
                result.add(typeMirror);
                Util.fillAllSuperTypes(types, typeMirror, result);
            }
        }
        catch (RuntimeException e) {
            LOG.debug("Failed to find all super types of type '" + Util.toHumanReadableString(type) + ". Possibly missing classes?", (Throwable)e);
        }
    }

    @Nonnull
    public static List<TypeMirror> getAllSuperInterfaces(@Nonnull Types types, @Nonnull TypeMirror type) {
        ArrayList<TypeMirror> ret = new ArrayList<TypeMirror>();
        Util.fillAllSuperInterfaces(types, type, ret);
        return ret;
    }

    public static void fillAllSuperInterfaces(@Nonnull Types types, @Nonnull TypeMirror type, @Nonnull List<TypeMirror> result) {
        try {
            List<? extends TypeMirror> superTypes = types.directSupertypes(type);
            SimpleTypeVisitor8<Boolean, Void> checker = new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

                @Override
                public Boolean visitDeclared(DeclaredType t, Void aVoid) {
                    return t.asElement().getKind() == ElementKind.INTERFACE;
                }
            };
            for (TypeMirror typeMirror : superTypes) {
                if (typeMirror.accept(checker, null).booleanValue()) {
                    result.add(typeMirror);
                }
                Util.fillAllSuperInterfaces(types, typeMirror, result);
            }
        }
        catch (RuntimeException e) {
            LOG.debug("Failed to find all super interfaces of type '" + Util.toHumanReadableString(type) + ". Possibly missing classes?", (Throwable)e);
        }
    }

    public static boolean isSubtype(@Nonnull TypeMirror type, @Nonnull List<? extends TypeMirror> superTypes, @Nonnull Types typeEnvironment) {
        List<TypeMirror> typeSuperTypes = Util.getAllSuperTypes(typeEnvironment, type);
        typeSuperTypes.add(0, type);
        for (TypeMirror t : typeSuperTypes) {
            String oldi = Util.toUniqueString(t);
            for (TypeMirror typeMirror : superTypes) {
                String newi = Util.toUniqueString(typeMirror);
                if (!oldi.equals(newi)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> keyAnnotationAttributesByName(@Nonnull Map<? extends ExecutableElement, ? extends AnnotationValue> attributes) {
        LinkedHashMap<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> result = new LinkedHashMap<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : attributes.entrySet()) {
            result.put(e.getKey().getSimpleName().toString(), e);
        }
        return result;
    }

    public static boolean isEqual(@Nonnull AnnotationValue oldVal, @Nonnull AnnotationValue newVal) {
        return oldVal.accept(new SimpleAnnotationValueVisitor7<Boolean, Object>(){

            @Override
            protected Boolean defaultAction(Object o, Object o2) {
                return o.equals(o2);
            }

            @Override
            public Boolean visitType(TypeMirror t, Object o) {
                if (!(o instanceof TypeMirror)) {
                    return false;
                }
                String os = Util.toUniqueString(t);
                String ns = Util.toUniqueString((TypeMirror)o);
                return os.equals(ns);
            }

            @Override
            public Boolean visitEnumConstant(VariableElement c, Object o) {
                return o instanceof VariableElement && c.getSimpleName().toString().equals(((VariableElement)o).getSimpleName().toString());
            }

            @Override
            public Boolean visitAnnotation(AnnotationMirror a, Object o) {
                String nt;
                if (!(o instanceof AnnotationMirror)) {
                    return false;
                }
                AnnotationMirror oa = (AnnotationMirror)o;
                String ot = Util.toUniqueString(a.getAnnotationType());
                if (!ot.equals(nt = Util.toUniqueString(oa.getAnnotationType()))) {
                    return false;
                }
                if (a.getElementValues().size() != oa.getElementValues().size()) {
                    return false;
                }
                Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> aVals = Util.keyAnnotationAttributesByName(a.getElementValues());
                Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> oVals = Util.keyAnnotationAttributesByName(oa.getElementValues());
                for (Map.Entry<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> aVal : aVals.entrySet()) {
                    String os;
                    String name = aVal.getKey();
                    Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> aAttr = aVal.getValue();
                    Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> oAttr = oVals.get(name);
                    if (oAttr == null) {
                        return false;
                    }
                    String as = Util.toUniqueString(aAttr.getValue());
                    if (as.equals(os = Util.toUniqueString(oAttr.getValue()))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Boolean visitArray(List<? extends AnnotationValue> vals, Object o) {
                if (!(o instanceof List)) {
                    return false;
                }
                List ovals = (List)o;
                if (vals.size() != ovals.size()) {
                    return false;
                }
                for (int i = 0; i < vals.size(); ++i) {
                    if (vals.get(i).accept(this, ((AnnotationValue)ovals.get(i)).getValue()).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        }, newVal.getValue());
    }

    public static TypeElement findTypeByBinaryName(Elements elements, String binaryName) {
        return Util.findTypeByBinaryName(elements, new StringBuilder(binaryName));
    }

    private static TypeElement findTypeByBinaryName(Elements elements, StringBuilder binaryName) {
        int i;
        TypeElement ret;
        int lookups = 1;
        try {
            ret = elements.getTypeElement(binaryName);
            if (ret != null) {
                return Util.traceLookupResult(binaryName, ret, lookups);
            }
        }
        catch (Exception __) {
            return Util.traceLookupResult(binaryName, null, lookups);
        }
        int lastIndex = binaryName.length() - 1;
        ArrayList<Integer> tmpDollars = new ArrayList<Integer>(4);
        ArrayList<Integer> tmpDigits = new ArrayList<Integer>(4);
        int dollarPos = -1;
        while ((dollarPos = binaryName.indexOf("$", dollarPos + 1)) != -1) {
            if (dollarPos <= 0 || dollarPos >= lastIndex || binaryName.charAt(dollarPos - 1) == '.' || binaryName.charAt(dollarPos + 1) == '.') continue;
            tmpDollars.add(dollarPos);
            if (!Character.isDigit(binaryName.charAt(dollarPos + 1))) continue;
            tmpDigits.add(dollarPos + 1);
        }
        int[] dollarPoses = new int[tmpDollars.size()];
        for (int i2 = 0; i2 < dollarPoses.length; ++i2) {
            dollarPoses[i2] = (Integer)tmpDollars.get(i2);
        }
        int[] digitPoses = new int[tmpDigits.size()];
        for (i = 0; i < digitPoses.length; ++i) {
            digitPoses[i] = (Integer)tmpDigits.get(i);
        }
        if (Util.isValidDotConstellation(dollarPoses, digitPoses, dollarPoses.length)) {
            for (i = 0; i < dollarPoses.length; ++i) {
                binaryName.setCharAt(dollarPoses[i], '.');
            }
            try {
                ++lookups;
                ret = elements.getTypeElement(binaryName);
                if (ret != null) {
                    return Util.traceLookupResult(binaryName, ret, lookups);
                }
                for (i = 0; i < dollarPoses.length; ++i) {
                    binaryName.setCharAt(dollarPoses[i], '$');
                }
            }
            catch (Exception __) {
                return Util.traceLookupResult(binaryName, null, lookups);
            }
        }
        int[] dotPoses = new int[dollarPoses.length];
        for (int nestingLevel = 1; ret == null && nestingLevel < dollarPoses.length; ++nestingLevel) {
            Util.firstDotConstellation(dollarPoses, dotPoses, nestingLevel);
            boolean constellationFound = false;
            long constellations = Util.nChooseK(dollarPoses.length, nestingLevel);
            int attempt = 0;
            while ((long)attempt++ < constellations) {
                int i3;
                if (!Util.isValidDotConstellation(dotPoses, digitPoses, nestingLevel)) {
                    Util.nextDotConstellation(dollarPoses, dotPoses, nestingLevel);
                    continue;
                }
                constellationFound = true;
                for (i3 = 0; i3 < dotPoses.length; ++i3) {
                    if (dotPoses[i3] == -1) continue;
                    binaryName.setCharAt(dotPoses[i3], '.');
                }
                try {
                    ++lookups;
                    ret = elements.getTypeElement(binaryName);
                    if (ret != null) {
                        break;
                    }
                }
                catch (Exception e) {
                    return Util.traceLookupResult(binaryName, null, lookups);
                }
                for (i3 = 0; i3 < dotPoses.length; ++i3) {
                    if (dotPoses[i3] == -1) continue;
                    binaryName.setCharAt(dotPoses[i3], '$');
                }
                Util.nextDotConstellation(dollarPoses, dotPoses, nestingLevel);
            }
            if (!constellationFound) break;
        }
        return Util.traceLookupResult(binaryName, ret, lookups);
    }

    private static TypeElement traceLookupResult(CharSequence binaryName, TypeElement ret, int lookups) {
        if (LOG.isTraceEnabled()) {
            if (ret != null) {
                LOG.trace(binaryName + ": " + lookups + " lookups to success.");
            } else {
                LOG.trace(binaryName + ": " + lookups + " lookups to failure.");
            }
        }
        return ret;
    }

    private static void firstDotConstellation(int[] dollarPositions, int[] dotPositions, int nestingLevel) {
        int i;
        int unassigned = dotPositions.length - nestingLevel;
        for (i = 0; i < unassigned; ++i) {
            dotPositions[i] = -1;
        }
        while (i < dotPositions.length) {
            dotPositions[i] = dollarPositions[i];
            ++i;
        }
    }

    private static void nextDotConstellation(int[] dollarPositions, int[] dotPositions, int nestingLevel) {
        if (nestingLevel == 0) {
            return;
        }
        int firstAssignedIdx = 0;
        while (dotPositions[firstAssignedIdx] == -1) {
            ++firstAssignedIdx;
        }
        if (firstAssignedIdx > 0) {
            dotPositions[firstAssignedIdx] = -1;
            dotPositions[--firstAssignedIdx] = dollarPositions[firstAssignedIdx];
        } else {
            int nofAssigned = 0;
            while (firstAssignedIdx < dotPositions.length && dotPositions[firstAssignedIdx++] != -1) {
                ++nofAssigned;
            }
            if (nofAssigned < nestingLevel) {
                while (firstAssignedIdx < dotPositions.length && dotPositions[firstAssignedIdx] == -1) {
                    ++firstAssignedIdx;
                }
                if (firstAssignedIdx < dotPositions.length && firstAssignedIdx > 0) {
                    dotPositions[firstAssignedIdx] = -1;
                    dotPositions[--firstAssignedIdx] = dollarPositions[firstAssignedIdx];
                }
            }
        }
    }

    private static long nChooseK(long n, long k) {
        if (n < k) {
            return 0L;
        }
        if (k == 0L || k == n) {
            return 1L;
        }
        if (k == 1L) {
            return n;
        }
        if (k == 2L) {
            return n * (n - 1L) / 2L;
        }
        return Util.nChooseK(n - 1L, k - 1L) + Util.nChooseK(n - 1L, k);
    }

    private static boolean isValidDotConstellation(int[] dotPositions, int[] digitPositions, int nestingLevel) {
        int assigned = 0;
        int lastAssignedIndex = -1;
        for (int i = 0; i < dotPositions.length; ++i) {
            if (dotPositions[i] == -1) continue;
            if (lastAssignedIndex != -1 && dotPositions[lastAssignedIndex] == dotPositions[i] - 1) {
                return false;
            }
            int classNameStartIndex = dotPositions[i] + 1;
            for (int j = 0; j < digitPositions.length; ++j) {
                if (digitPositions[j] == classNameStartIndex) {
                    return false;
                }
                if (digitPositions[j] > classNameStartIndex) break;
            }
            ++assigned;
            lastAssignedIndex = i;
        }
        return assigned == nestingLevel;
    }

    private static class DepthTrackingVisitor<T, S>
    extends SimpleTypeVisitor8<T, StringBuilderAndState<S>> {
        private DepthTrackingVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitIntersection(IntersectionType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitIntersection(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitIntersection(IntersectionType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitUnion(UnionType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitUnion(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitUnion(UnionType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitPrimitive(PrimitiveType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitPrimitive(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitPrimitive(PrimitiveType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitNull(NullType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitNull(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitNull(NullType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitArray(ArrayType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitArray(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitArray(ArrayType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitDeclared(DeclaredType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitDeclared(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitDeclared(DeclaredType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitError(ErrorType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitError(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitError(ErrorType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitTypeVariable(TypeVariable t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitTypeVariable(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitTypeVariable(TypeVariable t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitWildcard(WildcardType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitWildcard(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitWildcard(WildcardType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitExecutable(ExecutableType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitExecutable(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitExecutable(ExecutableType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitNoType(NoType t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitNoType(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitNoType(NoType t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T visitUnknown(TypeMirror t, StringBuilderAndState<S> st) {
            try {
                ++st.depth;
                T t2 = this.doVisitUnknown(t, st);
                return t2;
            }
            finally {
                --st.depth;
            }
        }

        protected T doVisitUnknown(TypeMirror t, StringBuilderAndState<S> st) {
            return (T)this.defaultAction(t, st);
        }
    }

    private static class StringBuilderAndState<T> {
        final StringBuilder bld = new StringBuilder();
        final Set<T> visitedObjects = new HashSet<T>(4);
        final Set<Name> forwardTypeVarDecls = new HashSet<Name>(2);
        Function<StringBuilderAndState<T>, Runnable> methodInitAndNameOutput;
        boolean visitingMethod;
        int depth;
        int anticipatedTypeVarDeclDepth;

        private StringBuilderAndState() {
        }
    }
}

