/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match;

import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.revapi.classif.util.Globbed;
import org.revapi.classif.util.LogUtil;

public abstract class NameMatch
implements Globbed {
    private static final Logger LOG = LogManager.getLogger(NameMatch.class);

    private NameMatch() {
    }

    @Override
    public boolean isMatchAll() {
        return false;
    }

    @Override
    public boolean isMatchAny() {
        return false;
    }

    public String getExactMatch() {
        return null;
    }

    public Pattern getPattern() {
        return null;
    }

    public static NameMatch exact(String name) {
        return new MatchExact(name);
    }

    public static NameMatch pattern(Pattern name) {
        return new MatchPattern(name);
    }

    public static NameMatch any() {
        return new MatchAny();
    }

    public static NameMatch all() {
        return new MatchAll();
    }

    public abstract boolean matches(String var1);

    private static final class MatchExact
    extends NameMatch {
        private final String match;

        private MatchExact(String match) {
            this.match = match;
        }

        @Override
        public String getExactMatch() {
            return this.match;
        }

        @Override
        public boolean matches(String name) {
            return LOG.traceExit(LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this, "name", (Object)name)), Boolean.valueOf(this.match.equals(name)));
        }

        public String toString() {
            return this.match;
        }
    }

    private static final class MatchPattern
    extends NameMatch {
        private final Pattern pattern;

        private MatchPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public boolean matches(String name) {
            return LOG.traceExit(LogUtil.traceParams(LOG, "this", (Object)this, "name", (Object)name), Boolean.valueOf(this.pattern.matcher(name).matches()));
        }

        public String toString() {
            return "/" + this.pattern.toString() + "/";
        }
    }

    private static final class MatchAny
    extends NameMatch {
        private MatchAny() {
        }

        @Override
        public boolean isMatchAny() {
            return true;
        }

        @Override
        public boolean matches(String name) {
            return LOG.traceExit(LogUtil.traceParams(LOG, "this", (Object)this), Boolean.valueOf(true));
        }

        public String toString() {
            return "*";
        }
    }

    private static final class MatchAll
    extends NameMatch {
        private MatchAll() {
        }

        @Override
        public boolean matches(String name) {
            return LOG.traceExit(LogUtil.traceParams(LOG, "this", (Object)this), Boolean.valueOf(true));
        }

        @Override
        public boolean isMatchAll() {
            return true;
        }

        public String toString() {
            return "**";
        }
    }
}

