/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match;

public enum Operator {
    EQ,
    NE,
    LT,
    LE,
    GT,
    GE;


    public <T extends Comparable<T>> boolean satisfied(T o1, T o2) {
        switch (this) {
            case EQ: {
                return o1.compareTo(o2) == 0;
            }
            case NE: {
                return o1.compareTo(o2) != 0;
            }
            case LT: {
                return o1.compareTo(o2) < 0;
            }
            case LE: {
                return o1.compareTo(o2) <= 0;
            }
            case GT: {
                return o1.compareTo(o2) > 0;
            }
            case GE: {
                return o1.compareTo(o2) >= 0;
            }
        }
        return true;
    }

    public String toString() {
        switch (this) {
            case EQ: {
                return "=";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case LE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GE: {
                return ">=";
            }
        }
        return "??";
    }
}

