/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.Map;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.NameMatch;
import org.revapi.classif.match.declaration.AnnotationValueMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.util.Globbed;
import org.revapi.classif.util.LogUtil;

public final class AnnotationAttributeMatch
implements Globbed {
    private static final Logger LOG = LogManager.getLogger(AnnotationAttributeMatch.class);
    private final boolean isAny;
    private final boolean isAll;
    private final NameMatch name;
    private final AnnotationValueMatch valueMatch;

    public AnnotationAttributeMatch(boolean isAny, boolean isAll, NameMatch name, AnnotationValueMatch valueMatch) {
        this.isAny = isAny;
        this.isAll = isAll;
        this.name = name;
        this.valueMatch = valueMatch;
    }

    @Override
    public boolean isMatchAny() {
        return LOG.traceExit(this.isAny || this.name != null && this.valueMatch != null && this.name.isMatchAny() && this.valueMatch.isMatchAny());
    }

    @Override
    public boolean isMatchAll() {
        return LOG.traceExit(this.isAll);
    }

    public <M> TestResult test(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> attribute, MatchContext<M> matchContext) {
        return LOG.traceExit(LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this, "attribute", attribute, "ctx", matchContext)), TestResult.fromBoolean(this.isMatchAny() || this.isMatchAll() || this.name == null || this.name.matches(attribute.getKey().getSimpleName().toString())).and(() -> {
            if (this.valueMatch == null) {
                return TestResult.PASSED;
            }
            return this.valueMatch.test((ExecutableElement)attribute.getKey(), (AnnotationValue)attribute.getValue(), matchContext);
        }));
    }

    public String toString() {
        if (this.isAny) {
            return "*";
        }
        if (this.isAll) {
            return "**";
        }
        return "" + this.name + " " + this.valueMatch;
    }
}

