/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.AnnotationAttributeMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.util.Glob;
import org.revapi.classif.util.LogUtil;

public final class AnnotationMatch {
    private static final Logger LOG = LogManager.getLogger(AnnotationMatch.class);
    private final boolean negation;
    private final TypeReferenceMatch type;
    private final Glob<AnnotationAttributeMatch> attributes;

    public AnnotationMatch(boolean negation, TypeReferenceMatch type, List<AnnotationAttributeMatch> attributes) {
        this.negation = negation;
        this.type = type;
        this.attributes = new Glob<AnnotationAttributeMatch>(attributes);
    }

    public <M> TestResult test(AnnotationMirror a, MatchContext<M> ctx) {
        EntryMessage methodTrace = LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this, "annotation", (Object)a, "ctx", ctx));
        TestResult ret = this.type.testInstance(a.getAnnotationType(), ctx).and(() -> this.attributes.testUnorderedWithOptionals((m, at) -> m.test((Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>)at, ctx), this.explicitAttributes(a).entrySet(), this.defaultAttributes(a).entrySet()));
        return LOG.traceExit(methodTrace, this.negation ? ret.negate() : ret);
    }

    public boolean isNegation() {
        return this.negation;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        if (this.negation) {
            bld.append("!");
        }
        bld.append("@").append(this.type);
        bld.append("(");
        bld.append(this.attributes.getMatches().stream().map(Object::toString).collect(Collectors.joining(", ")));
        bld.append(")");
        return bld.toString();
    }

    private Map<ExecutableElement, AnnotationValue> explicitAttributes(AnnotationMirror a) {
        return a.getElementValues();
    }

    private Map<ExecutableElement, AnnotationValue> defaultAttributes(AnnotationMirror a) {
        LinkedHashMap<? extends ExecutableElement, ? extends AnnotationValue> explicit = new LinkedHashMap<ExecutableElement, AnnotationValue>(a.getElementValues());
        LinkedHashMap<ExecutableElement, AnnotationValue> ret = new LinkedHashMap<ExecutableElement, AnnotationValue>(a.getElementValues());
        DeclaredType type = a.getAnnotationType();
        for (ExecutableElement m : ElementFilter.methodsIn(type.asElement().getEnclosedElements())) {
            if (explicit.containsKey(m)) continue;
            ret.put(m, m.getDefaultValue());
        }
        return ret;
    }
}

