/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.revapi.classif.ModelInspector;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.progress.context.MatchContext;

public final class OverridesMatch
extends DeclarationMatch {
    private final TypeReferenceMatch declaringType;

    public OverridesMatch(TypeReferenceMatch declaringType) {
        this.declaringType = declaringType;
    }

    @Override
    protected <M> TestResult testMethod(ExecutableElement declaration, TypeMirror instantiation, MatchContext<M> ctx) {
        if (instantiation.getKind() != TypeKind.EXECUTABLE) {
            return TestResult.NOT_PASSED;
        }
        TypeElement methodDeclaringType = (TypeElement)declaration.getEnclosingElement();
        ModelInspector<M> insp = ctx.getModelInspector();
        for (TypeMirror type : OverridesMatch.allSuperTypes(methodDeclaringType.asType(), insp)) {
            if (this.declaringType != null) {
                TestResult typeTest = this.declaringType.testInstance(type, ctx);
                if (typeTest == TestResult.NOT_PASSED) continue;
                if (typeTest == TestResult.DEFERRED) {
                    return typeTest;
                }
            }
            DeclaredType superType = (DeclaredType)type;
            List<ExecutableElement> methods = ElementFilter.methodsIn(superType.asElement().getEnclosedElements());
            for (ExecutableElement el : methods) {
                if (!insp.overrides(declaration, el, methodDeclaringType)) continue;
                return TestResult.PASSED;
            }
        }
        return TestResult.NOT_PASSED;
    }

    public String toString() {
        String ret = "overrides";
        if (this.declaringType != null) {
            ret = ret + " from " + this.declaringType;
        }
        return ret;
    }

    private static List<TypeMirror> allSuperTypes(TypeMirror type, ModelInspector<?> insp) {
        List<TypeMirror> directSuperTypes;
        ArrayList<TypeMirror> ret = new ArrayList<TypeMirror>();
        while (!(directSuperTypes = insp.directSupertypes(type)).isEmpty()) {
            type = directSuperTypes.get(0);
            ret.add(type);
        }
        return ret;
    }
}

