/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.Objects;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.declaration.TypeKind;
import org.revapi.classif.progress.context.MatchContext;

public final class TypeKindMatch
extends DeclarationMatch {
    private final boolean negation;
    private final TypeKind kind;

    public TypeKindMatch(boolean negation, TypeKind typeKind) {
        this.negation = negation;
        this.kind = Objects.requireNonNull(typeKind);
    }

    @Override
    protected <M> TestResult testType(TypeElement type, TypeMirror instantiation, MatchContext<M> ctx) {
        boolean matches = this.kind.matches(type.getKind());
        return TestResult.fromBoolean(this.negation != matches);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        if (this.negation) {
            bld.append("!");
        }
        bld.append(this.kind.toString());
        return bld.toString();
    }
}

