/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match.declaration;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.declaration.UseVisitor;
import org.revapi.classif.progress.StatementMatch;
import org.revapi.classif.progress.context.MatchContext;

public final class UsedByMatch
extends DeclarationMatch {
    private final boolean onlyDirect;
    private final List<String> referencedVariables;

    public UsedByMatch(boolean onlyDirect, List<String> referencedVariables) {
        this.onlyDirect = onlyDirect;
        this.referencedVariables = referencedVariables;
    }

    @Override
    protected <M> TestResult testType(TypeElement declaration, TypeMirror instantiation, MatchContext<M> ctx) {
        TypeVisitor<Stream<Element>, ?> visitor = UseVisitor.findUseSites(ctx.getModelInspector());
        Stream<Element> directUseSites = visitor.visit(instantiation);
        if (this.onlyDirect) {
            return TestResult.TestableStream.testable(directUseSites).testAny(us -> TestResult.TestableStream.testable(this.referencedVariables).testAny(v -> {
                StatementMatch m = ctx.getVariableMatcher((String)v);
                return m == null ? TestResult.NOT_PASSED : m.test(ctx.getModelInspector().fromElement((Element)us), ctx);
            }));
        }
        return this.testRecursively(directUseSites, ctx, UseVisitor.findUseSites(ctx.getModelInspector()));
    }

    private <M> TestResult testRecursively(Stream<Element> sites, MatchContext<M> ctx, TypeVisitor<Stream<Element>, ?> visitor) {
        if (sites == null) {
            return TestResult.DEFERRED;
        }
        return TestResult.TestableStream.testable(sites).testAny(us -> TestResult.TestableStream.testable(this.referencedVariables).testAny(v -> {
            StatementMatch m = ctx.getVariableMatcher((String)v);
            return m == null ? TestResult.NOT_PASSED : m.test(ctx.getModelInspector().fromElement((Element)us), ctx).or(() -> this.testRecursively((Stream)visitor.visit(us.asType()), ctx, visitor));
        }));
    }

    public String toString() {
        return "usedby " + (this.onlyDirect ? "directly " : "") + this.referencedVariables.stream().map(v -> "%" + v).collect(Collectors.joining(" | "));
    }
}

