/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaTypeElement;

public final class Removed
extends CheckBase {
    private Set<Archive> primaryApi;

    @Override
    public void initialize(@Nonnull AnalysisContext analysisContext) {
        super.initialize(analysisContext);
        this.primaryApi = new HashSet<Archive>(2);
        analysisContext.getOldApi().getArchives().forEach(this.primaryApi::add);
    }

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    @Override
    protected void doVisitClass(JavaTypeElement oldType, JavaTypeElement newType) {
        if (oldType != null && newType == null && this.isAccessible(oldType)) {
            this.pushActive(oldType, null, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types != null) {
            Difference difference = this.primaryApi.contains(((JavaTypeElement)types.oldElement).getArchive()) ? this.createDifference(Code.CLASS_REMOVED, Code.attachmentsFor((JavaTypeElement)types.oldElement, (JavaTypeElement)types.newElement, new String[0])) : this.createDifference(Code.CLASS_EXTERNAL_CLASS_NO_LONGER_EXPOSED_IN_API, Code.attachmentsFor((JavaTypeElement)types.oldElement, (JavaTypeElement)types.newElement, new String[0]));
            return Collections.singletonList(difference);
        }
        return null;
    }
}

