/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaMethodParameterElement;
import org.revapi.java.spi.Util;

public final class ParameterTypeChanged
extends CheckBase {
    private boolean skip;

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD, Check.Type.METHOD_PARAMETER);
    }

    @Override
    protected void doVisitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
        this.skip = oldMethod == null || newMethod == null || oldMethod.getModelRepresentation().getParameterTypes().size() != newMethod.getModelRepresentation().getParameterTypes().size();
    }

    @Override
    protected void doVisitMethodParameter(@Nullable JavaMethodParameterElement oldParameter, @Nullable JavaMethodParameterElement newParameter) {
        if (this.skip || oldParameter == null || newParameter == null) {
            return;
        }
        if (!this.isBothAccessible(oldParameter.getParent(), newParameter.getParent())) {
            return;
        }
        TypeMirror oldType = oldParameter.getModelRepresentation();
        String oldParam = Util.toUniqueString(oldType);
        String oldErasedParam = Util.toUniqueString(this.getOldTypeEnvironment().getTypeUtils().erasure(oldParameter.getDeclaringElement().asType()));
        TypeMirror newType = newParameter.getModelRepresentation();
        String newParam = Util.toUniqueString(newType);
        String newErasedParam = Util.toUniqueString(this.getNewTypeEnvironment().getTypeUtils().erasure(newParameter.getDeclaringElement().asType()));
        if (!oldParam.equals(newParam) || !oldErasedParam.equals(newErasedParam)) {
            this.pushActive(oldParameter, newParameter, oldParam, oldErasedParam, newParam, newErasedParam);
        }
    }

    @Override
    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements params = this.popIfActive();
        if (params == null) {
            return null;
        }
        String oldParam = (String)params.context[0];
        String oldErasedParam = (String)params.context[1];
        String newParam = (String)params.context[2];
        String newErasedParam = (String)params.context[3];
        String oldType = Util.toHumanReadableString(((JavaMethodParameterElement)params.oldElement).getModelRepresentation());
        String newType = Util.toHumanReadableString(((JavaMethodParameterElement)params.newElement).getModelRepresentation());
        if (!oldErasedParam.equals(newErasedParam)) {
            if (oldParam.equals(newParam)) {
                oldType = Util.toHumanReadableString(this.getOldTypeEnvironment().getTypeUtils().erasure(((JavaMethodParameterElement)params.oldElement).getDeclaringElement().asType()));
                newType = Util.toHumanReadableString(this.getNewTypeEnvironment().getTypeUtils().erasure(((JavaMethodParameterElement)params.newElement).getDeclaringElement().asType()));
                return Collections.singletonList(this.createDifference(Code.METHOD_PARAMETER_TYPE_ERASURE_CHANGED, Code.attachmentsFor((JavaMethodParameterElement)params.oldElement, (JavaMethodParameterElement)params.newElement, "oldType", oldType, "newType", newType)));
            }
            return Collections.singletonList(this.createDifference(Code.METHOD_PARAMETER_TYPE_CHANGED, Code.attachmentsFor((JavaMethodParameterElement)params.oldElement, (JavaMethodParameterElement)params.newElement, "oldType", oldType, "newType", newType)));
        }
        return Collections.singletonList(this.createDifference(Code.METHOD_PARAMETER_TYPE_PARAMETER_CHANGED, Code.attachmentsFor((JavaMethodParameterElement)params.oldElement, (JavaMethodParameterElement)params.newElement, "oldType", oldType, "newType", newType)));
    }
}

