/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaMethodElement;

public final class Varargs
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    @Override
    protected void doVisitMethod(JavaMethodElement oldMethod, JavaMethodElement newMethod) {
        if (newMethod != null && newMethod.getDeclaringElement().isVarArgs()) {
            this.pushActive(oldMethod, newMethod, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        JavaMethodElement method = (JavaMethodElement)methods.newElement;
        List<? extends TypeMirror> methodParams = method.getModelRepresentation().getParameterTypes();
        Types types = method.getTypeEnvironment().getTypeUtils();
        List methodsDifferingOnlyInVarargType = this.getOverloads(method).filter(m -> {
            if (!m.getDeclaringElement().isVarArgs()) {
                return false;
            }
            List<? extends TypeMirror> thisParams = m.getModelRepresentation().getParameterTypes();
            if (thisParams.size() != methodParams.size()) {
                return false;
            }
            for (int i = 0; i < methodParams.size() - 1; ++i) {
                if (types.isSameType((TypeMirror)methodParams.get(i), thisParams.get(i))) continue;
                return false;
            }
            return !types.isSameType((TypeMirror)methodParams.get(methodParams.size() - 1), thisParams.get(thisParams.size() - 1));
        }).collect(Collectors.toList());
        if (!methodsDifferingOnlyInVarargType.isEmpty()) {
            return Collections.singletonList(this.createDifferenceWithExplicitParams(Code.METHOD_VARARG_OVERLOADS_ONLY_DIFFER_IN_VARARG_PARAMETER, Code.attachmentsFor((JavaMethodElement)methods.oldElement, method, new String[0]), methodsDifferingOnlyInVarargType.toString()));
        }
        return null;
    }

    private Stream<JavaMethodElement> getOverloads(JavaMethodElement method) {
        return method.getParent().stream(JavaMethodElement.class, false).filter(m -> m.getDeclaringElement().getSimpleName().toString().equals(method.getDeclaringElement().getSimpleName().toString()));
    }
}

