/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceAnalyzer;
import org.revapi.Element;
import org.revapi.Reference;
import org.revapi.Report;
import org.revapi.Stats;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.Timing;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.AnnotationElement;
import org.revapi.java.model.FieldElement;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MethodParameterElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.JavaAnnotationElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaFieldElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaMethodParameterElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.UseSite;
import org.revapi.java.spi.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaElementDifferenceAnalyzer
implements DifferenceAnalyzer<JavaElement> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaElementDifferenceAnalyzer.class);
    private static final Map<Check.Type, Set<Check.Type>> POSSIBLE_CHILDREN_TYPES;
    private final AnalysisConfiguration analysisConfiguration;
    private final ResourceBundle messages;
    private final ProbingEnvironment oldEnvironment;
    private final ProbingEnvironment newEnvironment;
    private final Map<Check.Type, List<Check>> checksByInterest;
    private final Deque<Collection<Check>> checksStack = new ArrayDeque<Collection<Check>>();
    private List<Difference> lastAnnotationResults;
    private boolean nonExistenceMode;
    private JavaElement nonExistenceOldRoot;
    private JavaElement nonExistenceNewRoot;
    private final Map<Check.Type, Set<Check>> descendingChecksByTypes = new HashMap<Check.Type, Set<Check>>();

    public JavaElementDifferenceAnalyzer(AnalysisContext analysisContext, ProbingEnvironment oldEnvironment, ProbingEnvironment newEnvironment, Iterable<Check> checks, AnalysisConfiguration analysisConfiguration) {
        for (Check c2 : checks) {
            c2.setOldTypeEnvironment((TypeEnvironment)oldEnvironment);
            c2.setNewTypeEnvironment((TypeEnvironment)newEnvironment);
            if (!c2.isDescendingOnNonExisting()) continue;
            c2.getInterest().forEach(t -> this.descendingChecksByTypes.computeIfAbsent((Check.Type)t, __ -> new HashSet()).add(c2));
        }
        this.analysisConfiguration = analysisConfiguration;
        this.messages = ResourceBundle.getBundle("org.revapi.java.messages", analysisContext.getLocale());
        this.oldEnvironment = oldEnvironment;
        this.newEnvironment = newEnvironment;
        this.checksByInterest = new EnumMap<Check.Type, List<Check>>(Check.Type.class);
        checks.forEach(c -> c.getInterest().forEach(i -> this.checksByInterest.computeIfAbsent((Check.Type)i, __ -> new ArrayList()).add(c)));
    }

    public void open() {
        Timing.LOG.debug("Opening difference analyzer.");
    }

    public void close() {
        Timing.LOG.debug("Difference analyzer closed.");
    }

    public void beginAnalysis(@Nullable JavaElement oldElement, @Nullable JavaElement newElement) {
        Collection possibleChecks;
        Timing.LOG.trace("Beginning analysis of {} and {}.", (Object)oldElement, (Object)newElement);
        Check.Type elementsType = this.getCheckType(oldElement, newElement);
        Collection collection = possibleChecks = this.nonExistenceMode ? (Collection)this.descendingChecksByTypes.getOrDefault(elementsType, Collections.emptySet()) : (Collection)this.checksByInterest.get(elementsType);
        if (this.conforms(oldElement, newElement, TypeElement.class)) {
            this.checksStack.push(possibleChecks);
            this.lastAnnotationResults = null;
            for (Check c : possibleChecks) {
                Stats.of((String)c.getClass().getName()).start();
                c.visitClass((JavaTypeElement)(oldElement == null ? null : (TypeElement)oldElement), (JavaTypeElement)(newElement == null ? null : (TypeElement)newElement));
                Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
            }
        } else if (this.conforms(oldElement, newElement, AnnotationElement.class)) {
            if (this.lastAnnotationResults == null) {
                this.lastAnnotationResults = new ArrayList<Difference>(4);
            }
            for (Check c : possibleChecks) {
                Stats.of((String)c.getClass().getName()).start();
                List cps = c.visitAnnotation((JavaAnnotationElement)(oldElement == null ? null : (AnnotationElement)oldElement), (JavaAnnotationElement)(newElement == null ? null : (AnnotationElement)newElement));
                if (cps != null) {
                    this.lastAnnotationResults.addAll(cps);
                }
                Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
            }
        } else if (this.conforms(oldElement, newElement, FieldElement.class)) {
            this.doRestrictedCheck((FieldElement)oldElement, (FieldElement)newElement, Check.Type.FIELD, possibleChecks);
        } else if (this.conforms(oldElement, newElement, MethodElement.class)) {
            this.doRestrictedCheck((MethodElement)oldElement, (MethodElement)newElement, Check.Type.METHOD, possibleChecks);
        } else if (this.conforms(oldElement, newElement, MethodParameterElement.class)) {
            this.doRestrictedCheck((MethodParameterElement)oldElement, (MethodParameterElement)newElement, Check.Type.METHOD_PARAMETER, possibleChecks);
        }
        if (!(this.nonExistenceMode || oldElement != null && newElement != null)) {
            this.nonExistenceMode = true;
            this.nonExistenceOldRoot = oldElement;
            this.nonExistenceNewRoot = newElement;
        }
    }

    public boolean isDescendRequired(@Nullable JavaElement oldElement, @Nullable JavaElement newElement) {
        if (oldElement != null && newElement != null) {
            return true;
        }
        Check.Type type = this.getCheckType(oldElement, newElement);
        if (type == null) {
            return false;
        }
        Set<Check.Type> possibleChildren = POSSIBLE_CHILDREN_TYPES.get(type);
        return this.descendingChecksByTypes.keySet().stream().anyMatch(possibleChildren::contains);
    }

    private <T extends JavaModelElement> void doRestrictedCheck(T oldElement, T newElement, Check.Type interest, Collection<Check> possibleChecks) {
        this.lastAnnotationResults = null;
        if (!this.isCheckedElsewhere(oldElement, this.oldEnvironment) || !this.isCheckedElsewhere(newElement, this.newEnvironment)) {
            this.checksStack.push(possibleChecks);
            for (Check c : possibleChecks) {
                Stats.of((String)c.getClass().getName()).start();
                switch (interest) {
                    case FIELD: {
                        c.visitField((JavaFieldElement)((FieldElement)oldElement), (JavaFieldElement)((FieldElement)newElement));
                        break;
                    }
                    case METHOD: {
                        c.visitMethod((JavaMethodElement)((MethodElement)oldElement), (JavaMethodElement)((MethodElement)newElement));
                        break;
                    }
                    case METHOD_PARAMETER: {
                        c.visitMethodParameter((JavaMethodParameterElement)((MethodParameterElement)oldElement), (JavaMethodParameterElement)((MethodParameterElement)newElement));
                    }
                }
                Stats.of((String)c.getClass().getName()).end(oldElement, newElement);
            }
        } else {
            this.checksStack.push(Collections.emptyList());
        }
    }

    public Report endAnalysis(@Nullable JavaElement oldElement, @Nullable JavaElement newElement) {
        if (oldElement == this.nonExistenceOldRoot && newElement == this.nonExistenceNewRoot) {
            this.nonExistenceMode = false;
            this.nonExistenceOldRoot = null;
            this.nonExistenceNewRoot = null;
        }
        if (this.conforms(oldElement, newElement, AnnotationElement.class)) {
            return new Report(Collections.emptyList(), (Element)oldElement, (Element)newElement);
        }
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Collection<Check> lastChecks = this.checksStack.pop();
        for (Check c : lastChecks) {
            List p = c.visitEnd();
            if (p == null) continue;
            differences.addAll(p);
        }
        if (this.lastAnnotationResults != null && !this.lastAnnotationResults.isEmpty()) {
            differences.addAll(this.lastAnnotationResults);
            this.lastAnnotationResults.clear();
        }
        if (!differences.isEmpty()) {
            LOG.trace("Detected following problems: {}", differences);
        }
        Timing.LOG.trace("Ended analysis of {} and {}.", (Object)oldElement, (Object)newElement);
        ListIterator<Difference> it = differences.listIterator();
        while (it.hasNext()) {
            Difference d = (Difference)it.next();
            if (this.analysisConfiguration.reportUseForAllDifferences() || this.analysisConfiguration.getUseReportingCodes().contains(d.code)) {
                StringBuilder oldUseChain = null;
                StringBuilder newUseChain = null;
                if (oldElement != null) {
                    oldUseChain = new StringBuilder();
                    this.appendUses(this.oldEnvironment, oldElement, oldUseChain);
                }
                if (newElement != null) {
                    newUseChain = new StringBuilder();
                    this.appendUses(this.newEnvironment, newElement, newUseChain);
                }
                HashMap<String, String> atts = new HashMap<String, String>(d.attachments);
                if (oldUseChain != null) {
                    atts.put("exampleUseChainInOldApi", oldUseChain.toString());
                }
                if (newUseChain != null) {
                    atts.put("exampleUseChainInNewApi", newUseChain.toString());
                }
                d = ((Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)Difference.builder().addAttachments(atts)).addClassifications(d.classification)).withCode(d.code)).withName(d.name)).withDescription(d.description)).build();
            }
            it.set(d);
        }
        return new Report(differences, (Element)oldElement, (Element)newElement);
    }

    private <T> boolean conforms(Object a, Object b, Class<T> cls) {
        boolean ca = a == null || cls.isAssignableFrom(a.getClass());
        boolean cb = b == null || cls.isAssignableFrom(b.getClass());
        return ca && cb;
    }

    private Check.Type getCheckType(JavaElement a, JavaElement b) {
        if (a != null) {
            return this.getCheckType(a);
        }
        if (b != null) {
            return this.getCheckType(b);
        }
        return null;
    }

    private Check.Type getCheckType(JavaElement e) {
        if (e instanceof TypeElement) {
            return Check.Type.CLASS;
        }
        if (e instanceof AnnotationElement) {
            return Check.Type.ANNOTATION;
        }
        if (e instanceof FieldElement) {
            return Check.Type.FIELD;
        }
        if (e instanceof MethodElement) {
            return Check.Type.METHOD;
        }
        if (e instanceof MethodParameterElement) {
            return Check.Type.METHOD_PARAMETER;
        }
        return null;
    }

    private void append(StringBuilder bld, TypeAndUseSite typeAndUseSite) {
        String message;
        switch (typeAndUseSite.useSite.getType()) {
            case ANNOTATES: {
                message = "revapi.java.uses.annotates";
                break;
            }
            case HAS_TYPE: {
                message = "revapi.java.uses.hasType";
                break;
            }
            case IS_IMPLEMENTED: {
                message = "revapi.java.uses.isImplemented";
                break;
            }
            case IS_INHERITED: {
                message = "revapi.java.uses.isInherited";
                break;
            }
            case IS_THROWN: {
                message = "revapi.java.uses.isThrown";
                break;
            }
            case PARAMETER_TYPE: {
                message = "revapi.java.uses.parameterType";
                break;
            }
            case RETURN_TYPE: {
                message = "revapi.java.uses.returnType";
                break;
            }
            case CONTAINS: {
                message = "revapi.java.uses.contains";
                break;
            }
            case TYPE_PARAMETER_OR_BOUND: {
                message = "revapi.java.uses.typeParameterOrBound";
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid use type: " + typeAndUseSite.useSite.getType()));
            }
        }
        message = this.messages.getString(message);
        message = MessageFormat.format(message, ((JavaElement)typeAndUseSite.useSite.getElement()).getFullHumanReadableString(), Util.toHumanReadableString((AnnotatedConstruct)typeAndUseSite.type));
        bld.append(message);
    }

    private void appendUses(ProbingEnvironment env, JavaElement element, StringBuilder bld) {
        LOG.trace("Reporting uses of {}", (Object)element);
        if (element == null) {
            bld.append("<null>");
            return;
        }
        while (element != null && !(element instanceof JavaTypeElement)) {
            element = (JavaElement)element.getParent();
        }
        if (element == null) {
            return;
        }
        JavaTypeElement usedType = (JavaTypeElement)element;
        if (usedType.isInAPI() && !usedType.isInApiThroughUse()) {
            String message = MessageFormat.format(this.messages.getString("revapi.java.uses.partOfApi"), usedType.getFullHumanReadableString());
            bld.append(message);
            return;
        }
        for (Reference ref : usedType.getReferencingElements()) {
            if (!this.appendUse(env, usedType, bld, usedType.getModelRepresentation(), (UseSite)ref)) continue;
            break;
        }
    }

    private boolean appendUse(ProbingEnvironment env, JavaTypeElement usedType, StringBuilder bld, DeclaredType type, UseSite use) {
        if (!use.getType().isMovingToApi()) {
            return false;
        }
        List<TypeAndUseSite> chain = this.getExamplePathToApiArchive(env, usedType, type, use);
        if (chain.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not find example path to API element for type {} starting with use {}", (Object)((javax.lang.model.element.TypeElement)type.asElement()).getQualifiedName().toString(), (Object)use);
            }
            return false;
        }
        Iterator<TypeAndUseSite> chainIt = chain.iterator();
        TypeAndUseSite last = chainIt.next();
        this.append(bld, last);
        while (chainIt.hasNext()) {
            bld.append(" <- ");
            last = chainIt.next();
            this.append(bld, last);
        }
        String message = MessageFormat.format(this.messages.getString("revapi.java.uses.partOfApi"), ((JavaElement)last.useSite.getElement()).getFullHumanReadableString());
        bld.append(" (").append(message).append(")");
        return true;
    }

    private List<TypeAndUseSite> getExamplePathToApiArchive(ProbingEnvironment env, JavaTypeElement usedType, DeclaredType type, UseSite bottomUse) {
        ArrayList<TypeAndUseSite> ret = new ArrayList<TypeAndUseSite>();
        this.traverseToApi(env, usedType, type, bottomUse, ret, new HashSet<javax.lang.model.element.TypeElement>());
        return ret;
    }

    private boolean traverseToApi(ProbingEnvironment env, JavaTypeElement usedType, DeclaredType type, UseSite currentUse, List<TypeAndUseSite> path, Set<javax.lang.model.element.TypeElement> visitedTypes) {
        if (!currentUse.getType().isMovingToApi()) {
            return false;
        }
        JavaTypeElement ut = this.findClassOf((JavaElement)currentUse.getElement());
        return this.appendUseType(env, ut, path, usedType, type, currentUse, visitedTypes);
    }

    private boolean appendUseType(ProbingEnvironment env, JavaTypeElement ut, List<TypeAndUseSite> path, JavaTypeElement usedType, DeclaredType type, UseSite currentUse, Set<javax.lang.model.element.TypeElement> visitedTypes) {
        javax.lang.model.element.TypeElement useType = ut.getDeclaringElement();
        if (visitedTypes.contains(useType)) {
            return false;
        }
        visitedTypes.add(useType);
        if (ut.isInAPI() && !ut.isInApiThroughUse() && !ut.equals((Object)usedType)) {
            path.add(0, new TypeAndUseSite(type, currentUse));
            return true;
        }
        boolean ret = false;
        for (Reference ref : ut.getReferencingElements()) {
            if (!this.traverseToApi(env, ut, ut.getModelRepresentation(), (UseSite)ref, path, visitedTypes)) continue;
            path.add(0, new TypeAndUseSite(type, currentUse));
            ret = true;
            break;
        }
        if (!ret) {
            Set<javax.lang.model.element.TypeElement> derivedUseTypes = env.getDerivedTypes(useType);
            for (javax.lang.model.element.TypeElement dut : derivedUseTypes) {
                UseSite derivedUse;
                JavaModelElement derivedUseElement;
                TypeElement model = env.getTypeMap().get(dut);
                if (model == null || (derivedUseElement = this.findSameDeclarationUnder((JavaElement)currentUse.getElement(), model)) == null || !this.appendUseType(env, model, path, usedType, type, derivedUse = new UseSite(currentUse.getType(), (JavaElement)derivedUseElement), visitedTypes)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private JavaTypeElement findClassOf(JavaElement element) {
        while (element != null && !(element instanceof JavaTypeElement)) {
            element = (JavaElement)element.getParent();
        }
        return (JavaTypeElement)element;
    }

    private javax.lang.model.element.TypeElement findTypeOf(javax.lang.model.element.Element element) {
        while (element != null && !element.getKind().isClass() && !element.getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (javax.lang.model.element.TypeElement)element;
    }

    private JavaModelElement findSameDeclarationUnder(JavaElement declaredElement, JavaTypeElement owningElement) {
        if (!(declaredElement instanceof JavaModelElement)) {
            return null;
        }
        JavaModelElement dme = (JavaModelElement)declaredElement;
        for (JavaElement e : owningElement.getChildren()) {
            if (!(e instanceof JavaModelElement) || !((JavaModelElement)e).getDeclaringElement().equals(dme.getDeclaringElement())) continue;
            return (JavaModelElement)e;
        }
        return null;
    }

    private boolean isCheckedElsewhere(JavaModelElement element, ProbingEnvironment env) {
        String declSig;
        if (element == null) {
            return true;
        }
        if (!element.isInherited()) {
            return false;
        }
        String elementSig = Util.toUniqueString((TypeMirror)element.getModelRepresentation());
        if (!Objects.equals(elementSig, declSig = Util.toUniqueString((TypeMirror)element.getDeclaringElement().asType()))) {
            return false;
        }
        javax.lang.model.element.TypeElement declaringType = this.findTypeOf(element.getDeclaringElement());
        JavaTypeElement declaringClass = env.getTypeMap().get(declaringType);
        return declaringClass != null && declaringClass.isInAPI();
    }

    static {
        EnumMap<Check.Type, Set<Object>> map = new EnumMap<Check.Type, Set<Object>>(Check.Type.class);
        map.put(Check.Type.ANNOTATION, Collections.emptySet());
        map.put(Check.Type.CLASS, EnumSet.of(Check.Type.CLASS, Check.Type.FIELD, Check.Type.METHOD, Check.Type.METHOD_PARAMETER, Check.Type.ANNOTATION));
        map.put(Check.Type.FIELD, Collections.singleton(Check.Type.ANNOTATION));
        map.put(Check.Type.METHOD, EnumSet.of(Check.Type.METHOD_PARAMETER, Check.Type.ANNOTATION));
        map.put(Check.Type.METHOD_PARAMETER, Collections.singleton(Check.Type.ANNOTATION));
        POSSIBLE_CHILDREN_TYPES = Collections.unmodifiableMap(map);
    }

    private static class TypeAndUseSite {
        final DeclaredType type;
        final UseSite useSite;

        public TypeAndUseSite(DeclaredType type, UseSite useSite) {
            this.type = type;
            this.useSite = useSite;
        }
    }
}

