/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.transforms.annotations;

import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.TransformationResult;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.ElementPairVisitor;
import org.revapi.java.spi.JavaModelElement;

abstract class AbstractAnnotationPresenceCheck
implements DifferenceTransform<JavaModelElement> {
    protected AnalysisContext analysisContext;
    private final String annotationQualifiedName;
    private final Code transformedCode;
    private final Pattern[] codes;
    private final List<Predicate<String>> predicates;

    protected AbstractAnnotationPresenceCheck(String annotationQualifiedName, Code annotationCheckCode, Code transformedCode) {
        this.annotationQualifiedName = annotationQualifiedName;
        this.transformedCode = transformedCode;
        String regex = "^" + Pattern.quote(annotationCheckCode.code()) + "$";
        this.codes = new Pattern[]{Pattern.compile(regex)};
        this.predicates = Collections.singletonList(annotationCheckCode.code()::equals);
    }

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return this.codes;
    }

    @Nonnull
    public List<Predicate<String>> getDifferenceCodePredicates() {
        return this.predicates;
    }

    @Nullable
    public String getExtensionId() {
        return "<<<non-configurable-java-annotation-transform>>>";
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    public TransformationResult tryTransform(@Nullable JavaModelElement oldElement, @Nullable JavaModelElement newElement, final @Nonnull Difference difference) {
        if (oldElement == null || newElement == null) {
            return TransformationResult.keep();
        }
        String affectedAnnotation = (String)difference.attachments.get("annotationType");
        if (!this.annotationQualifiedName.equals(affectedAnnotation)) {
            return TransformationResult.keep();
        }
        Difference transformed = (Difference)oldElement.getDeclaringElement().accept(new ElementPairVisitor<Difference>(this){
            final /* synthetic */ AbstractAnnotationPresenceCheck this$0;
            {
                this.this$0 = this$0;
            }

            protected Difference unmatchedAction(@Nonnull Element element, @Nullable Element otherElement) {
                return difference;
            }

            protected Difference visitType(@Nonnull TypeElement oldElement, @Nonnull TypeElement newElement) {
                return this.common();
            }

            protected Difference visitPackage(@Nonnull PackageElement element, @Nonnull PackageElement otherElement) {
                return this.common();
            }

            protected Difference visitVariable(@Nonnull VariableElement element, @Nonnull VariableElement otherElement) {
                return this.common();
            }

            protected Difference visitExecutable(@Nonnull ExecutableElement element, @Nonnull ExecutableElement otherElement) {
                return this.common();
            }

            private Difference common() {
                return this.this$0.transformedCode.createDifference(this.this$0.analysisContext.getLocale(), new LinkedHashMap(difference.attachments));
            }
        }, newElement.getDeclaringElement());
        return TransformationResult.replaceWith((Difference)transformed);
    }

    public void close() throws Exception {
    }
}

