/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.VariableElement;
import org.revapi.Difference;
import org.revapi.java.checks.fields.BothFieldsRequiringCheck;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;

public final class ConstantValueChanged
extends BothFieldsRequiringCheck {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    @Override
    protected void doVisitField(VariableElement oldField, VariableElement newField) {
        if (!this.shouldCheck(oldField, newField)) {
            return;
        }
        Object oldC = oldField.getConstantValue();
        Object newC = newField.getConstantValue();
        if (oldC != null && newC != null && !oldC.equals(newC)) {
            this.pushActive(oldField, newField, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        return Collections.singletonList(this.createDifference(Code.FIELD_CONSTANT_VALUE_CHANGED, ((VariableElement)fields.oldElement).getConstantValue().toString(), ((VariableElement)fields.newElement).getConstantValue().toString()));
    }
}

