/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.java.compilation.RawUseSite;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.UseSite;

final class TypeRecord {
    private final String binaryName;
    private boolean apiType;
    private boolean apiThroughUse;
    private boolean explicitlyExcluded;
    private boolean explicitlyIncluded;
    private Set<RawUseSite> useSites;
    private Map<TypeRecord, EnumSet<UseSite.Type>> usedTypes;
    private TypeElement type;
    private TypeRecord owner;
    private int nestingDepth;
    private List<String> accessibleSubclasses;

    TypeRecord(String binaryName) {
        this.binaryName = binaryName;
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public boolean isApiType() {
        return this.apiType;
    }

    public void setApiType(boolean apiType) {
        this.apiType = apiType;
    }

    public boolean isApiThroughUse() {
        return this.apiThroughUse;
    }

    public void setApiThroughUse(boolean apiThroughUse) {
        this.apiThroughUse = apiThroughUse;
    }

    public boolean isExplicitlyExcluded() {
        return this.explicitlyExcluded;
    }

    public void setExplicitlyExcluded(boolean explicitlyExcluded) {
        this.explicitlyExcluded = explicitlyExcluded;
    }

    public boolean isExplicitlyIncluded() {
        return this.explicitlyIncluded;
    }

    public void setExplicitlyIncluded(boolean explicitlyIncluded) {
        this.explicitlyIncluded = explicitlyIncluded;
    }

    @Nonnull
    public Set<RawUseSite> getUseSites() {
        if (this.useSites == null) {
            this.useSites = new HashSet<RawUseSite>();
        }
        return this.useSites;
    }

    public boolean hasUseSites() {
        return this.useSites != null && !this.useSites.isEmpty();
    }

    @Nonnull
    public Map<TypeRecord, EnumSet<UseSite.Type>> getUsedTypes() {
        if (this.usedTypes == null) {
            this.usedTypes = new HashMap<TypeRecord, EnumSet<UseSite.Type>>();
        }
        return this.usedTypes;
    }

    public boolean hasUsedTypes() {
        return this.usedTypes != null && !this.usedTypes.isEmpty();
    }

    @Nullable
    public TypeElement getType() {
        return this.type;
    }

    public void setType(TypeElement type) {
        this.type = type;
    }

    public TypeRecord getOwner() {
        return this.owner;
    }

    public void setOwner(TypeRecord owner) {
        this.owner = owner;
    }

    public int getNestingDepth() {
        return this.nestingDepth;
    }

    public void setNestingDepth(int nestingDepth) {
        this.nestingDepth = nestingDepth;
    }

    public boolean isSomeSubclassAccessible() {
        return this.accessibleSubclasses != null && this.accessibleSubclasses.size() > 0;
    }

    public List<String> getAccessibleSubclasses() {
        if (this.accessibleSubclasses == null) {
            this.accessibleSubclasses = new ArrayList<String>();
        }
        return this.accessibleSubclasses;
    }

    public void addAccessibleSubclass(TypeRecord type) {
        this.getAccessibleSubclasses().add(type.binaryName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof TypeRecord)) {
            return false;
        }
        TypeRecord that = (TypeRecord)o;
        return this.binaryName.equals(that.binaryName);
    }

    public int hashCode() {
        return this.binaryName.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TypeRecord[");
        sb.append("binaryName='").append(this.binaryName).append('\'');
        sb.append(", apiType=").append(this.apiType);
        sb.append(']');
        return sb.toString();
    }
}

