/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.spi;

import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.lang.model.util.SimpleElementVisitor8;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.UseSite;

public abstract class CheckBase
implements Check {
    private static final UseSite.Visitor<Boolean, Void> NOOP_USE_CHECK = new UseSite.Visitor<Boolean, Void>(){

        @Override
        @Nullable
        public Boolean visit(@Nonnull TypeElement type, @Nonnull UseSite use, @Nullable Void parameter) {
            return null;
        }

        @Override
        @Nullable
        public Boolean end(TypeElement type, @Nullable Void parameter) {
            return false;
        }
    };
    private TypeEnvironment oldTypeEnvironment;
    private TypeEnvironment newTypeEnvironment;
    private int depth;
    private boolean dummyRun;
    private final Deque<ActiveElements<?>> activations = new ArrayDeque();
    private AnalysisContext analysisContext;
    private boolean skipUseTracking;

    public boolean isBothPrivate(@Nullable Element a, TypeEnvironment envA, @Nullable Element b, TypeEnvironment envB) {
        if (a == null || b == null) {
            return false;
        }
        return !this.isAccessible(a, envA) && !this.isAccessible(b, envB);
    }

    public boolean isBothAccessible(@Nullable Element a, @Nonnull TypeEnvironment envA, @Nullable Element b, @Nonnull TypeEnvironment envB) {
        if (a == null || b == null) {
            return false;
        }
        return this.isAccessible(a, envA) && this.isAccessible(b, envB);
    }

    public boolean isAccessible(@Nonnull Element e, @Nonnull TypeEnvironment env) {
        return this.isAccessible(e, env, this.skipUseTracking ? Collections.emptySet() : new HashSet(1));
    }

    private boolean isAccessible(Element e, final TypeEnvironment env, final Set<TypeElement> visitedTypes) {
        if (!this.isAccessibleByModifier(e)) {
            return e instanceof TypeElement && this.isUsedSignificantly((TypeElement)e, env, visitedTypes);
        }
        return e.accept(new SimpleElementVisitor8<Boolean, Void>(Boolean.valueOf(true)){

            @Override
            public Boolean visitType(TypeElement e, Void v) {
                if (CheckBase.this.isAllEnclosersAccessible(e, env) || CheckBase.this.isUsedSignificantly(e, env, visitedTypes)) {
                    return true;
                }
                Element parent = e.getEnclosingElement();
                if (parent instanceof PackageElement) {
                    return true;
                }
                if (parent instanceof TypeElement) {
                    TypeElement tp = (TypeElement)parent;
                    if (CheckBase.this.isAllEnclosersAccessible(tp, env) || CheckBase.this.isUsedSignificantly(tp, env, visitedTypes)) {
                        return true;
                    }
                    Set<TypeElement> subclasses = env.getAccessibleSubclasses(tp);
                    return subclasses.stream().filter(t -> CheckBase.this.isAllEnclosersAccessible(t, env) || CheckBase.this.isUsedSignificantly(t, env, visitedTypes)).findAny().isPresent();
                }
                return false;
            }

            @Override
            public Boolean visitExecutable(ExecutableElement e, Void v) {
                return this.isAccessibleOrHasAccessibleSubclasses((TypeElement)e.getEnclosingElement());
            }

            @Override
            public Boolean visitVariable(VariableElement e, Void v) {
                return this.isAccessibleOrHasAccessibleSubclasses((TypeElement)e.getEnclosingElement());
            }

            private boolean isAccessibleOrHasAccessibleSubclasses(TypeElement type) {
                if (CheckBase.this.isAllEnclosersAccessible(type, env) || CheckBase.this.isUsedSignificantly(type, env, visitedTypes)) {
                    return true;
                }
                Set<TypeElement> subclasses = env.getAccessibleSubclasses(type);
                return subclasses.stream().filter(t -> CheckBase.this.isAllEnclosersAccessible(t, env) || CheckBase.this.isUsedSignificantly(t, env, visitedTypes)).findAny().isPresent();
            }
        }, null);
    }

    private boolean isAccessibleByModifier(Element e) {
        return !this.isMissing(e) && (e.getModifiers().contains((Object)Modifier.PUBLIC) || e.getModifiers().contains((Object)Modifier.PROTECTED));
    }

    private boolean isAllEnclosersAccessible(@Nonnull Element e, @Nonnull TypeEnvironment env) {
        while (e != null) {
            if (!(e instanceof PackageElement) && !this.isAccessibleByModifier(e)) {
                return false;
            }
            e = e.getEnclosingElement();
        }
        return true;
    }

    public boolean isMissing(@Nonnull Element e) {
        return e.asType().getKind() == TypeKind.ERROR;
    }

    private boolean isUsedSignificantly(@Nonnull TypeElement type, @Nonnull TypeEnvironment env, Set<TypeElement> visitedTypes) {
        return !this.skipUseTracking && this.isPubliclyUsedAs(type, env, UseSite.Type.allBut(UseSite.Type.IS_IMPLEMENTED, UseSite.Type.IS_INHERITED, UseSite.Type.CONTAINS), visitedTypes, NOOP_USE_CHECK);
    }

    public boolean isPubliclyUsedAs(@Nonnull TypeElement type, TypeEnvironment env, Collection<UseSite.Type> uses) {
        return this.isPubliclyUsedAs(type, env, uses, new HashSet<TypeElement>(), NOOP_USE_CHECK);
    }

    private boolean isPubliclyUsedAs(@Nonnull TypeElement type, final TypeEnvironment env, final Collection<UseSite.Type> uses, final Set<TypeElement> visitedElements, final UseSite.Visitor<Boolean, Void> noUseCheck) {
        Boolean isUsedSignificantly = env.visitUseSites(type, new UseSite.Visitor<Boolean, Void>(){
            private int nofUses;

            @Override
            @Nullable
            public Boolean visit(@Nonnull TypeElement type, @Nonnull UseSite use, @Nullable Void ignored) {
                if (visitedElements.contains(type)) {
                    return null;
                }
                visitedElements.add(type);
                boolean validUse = uses.contains((Object)use.getUseType());
                if (validUse && use.getSite() instanceof JavaModelElement) {
                    ++this.nofUses;
                    Element e = ((JavaModelElement)use.getSite()).getModelElement();
                    if (!CheckBase.this.isAccessible(e, env)) {
                        return null;
                    }
                    final UseSite.Visitor<Boolean, Void> effectiveAccessibilityEndCheck = new UseSite.Visitor<Boolean, Void>(){

                        @Override
                        @Nullable
                        public Boolean visit(@Nonnull TypeElement type, @Nonnull UseSite use, @Nullable Void parameter) {
                            return null;
                        }

                        @Override
                        @Nullable
                        public Boolean end(TypeElement type, @Nullable Void parameter) {
                            return CheckBase.this.isAllEnclosersAccessible(type, env);
                        }
                    };
                    return e.accept(new SimpleElementVisitor7<Boolean, Void>(){

                        @Override
                        public Boolean visitVariable(VariableElement e, Void ignored) {
                            return e.getEnclosingElement().accept(new SimpleElementVisitor7<Boolean, Void>(){

                                @Override
                                public Boolean visitType(TypeElement e, Void ignored) {
                                    return CheckBase.this.isPubliclyUsedAs(e, env, UseSite.Type.allBut(UseSite.Type.CONTAINS), visitedElements, effectiveAccessibilityEndCheck);
                                }
                            }, null);
                        }

                        @Override
                        public Boolean visitExecutable(ExecutableElement e, Void ignored) {
                            return e.getEnclosingElement().accept(new SimpleElementVisitor7<Boolean, Void>(){

                                @Override
                                public Boolean visitType(TypeElement e, Void ignored) {
                                    return CheckBase.this.isPubliclyUsedAs(e, env, UseSite.Type.allBut(UseSite.Type.CONTAINS), visitedElements, effectiveAccessibilityEndCheck);
                                }
                            }, null);
                        }

                        @Override
                        public Boolean visitType(TypeElement type, Void ignored) {
                            return type.getEnclosingElement().accept(new SimpleElementVisitor7<Boolean, Void>(){

                                @Override
                                public Boolean visitPackage(PackageElement e, Void ignored) {
                                    return true;
                                }

                                @Override
                                public Boolean visitType(TypeElement e, Void ignored) {
                                    return CheckBase.this.isPubliclyUsedAs(e, env, UseSite.Type.allBut(UseSite.Type.CONTAINS), visitedElements, effectiveAccessibilityEndCheck);
                                }
                            }, null);
                        }
                    }, null);
                }
                return null;
            }

            @Override
            @Nullable
            public Boolean end(TypeElement type, @Nullable Void parameter) {
                if (this.nofUses == 0) {
                    return (Boolean)noUseCheck.end(type, parameter);
                }
                return null;
            }
        }, null);
        return isUsedSignificantly != null && isUsedSignificantly != false;
    }

    public boolean isSkipUseTracking() {
        return this.skipUseTracking;
    }

    protected void setSkipUseTracking(boolean value) {
        this.skipUseTracking = value;
    }

    @Nonnull
    protected Difference createDifference(@Nonnull Code code, Object ... params) {
        return this.createDifference(code, params, params);
    }

    @Nonnull
    protected Difference createDifference(@Nonnull Code code, @Nullable Object[] params, Object ... attachments) {
        return code.createDifference(this.getAnalysisContext().getLocale(), params, attachments);
    }

    @Nonnull
    public TypeEnvironment getOldTypeEnvironment() {
        return this.oldTypeEnvironment;
    }

    @Nonnull
    public TypeEnvironment getNewTypeEnvironment() {
        return this.newTypeEnvironment;
    }

    @Nonnull
    public AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    @Nullable
    public String[] getConfigurationRootPaths() {
        return null;
    }

    @Nullable
    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
        ModelNode node = analysisContext.getConfiguration().get("revapi", "java", "deepUseChainAnalysis");
        this.skipUseTracking = !node.isDefined() || !node.asBoolean();
    }

    @Override
    public void setOldTypeEnvironment(@Nonnull TypeEnvironment env) {
        this.oldTypeEnvironment = env;
    }

    @Override
    public void setNewTypeEnvironment(@Nonnull TypeEnvironment env) {
        this.newTypeEnvironment = env;
    }

    @Override
    @Nullable
    public final List<Difference> visitEnd() {
        try {
            List<Difference> list = this.dummyRun ? null : this.doEnd();
            return list;
        }
        finally {
            this.popIfActive();
            --this.depth;
            this.dummyRun = false;
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        return null;
    }

    @Override
    public final void visitClass(@Nullable TypeElement oldType, @Nullable TypeElement newType) {
        ++this.depth;
        if (this.isPotentiallyInApi(oldType, newType)) {
            this.doVisitClass(oldType, newType);
        } else {
            this.dummyRun = true;
        }
    }

    protected void doVisitClass(@Nullable TypeElement oldType, @Nullable TypeElement newType) {
    }

    @Override
    public final void visitMethod(@Nullable ExecutableElement oldMethod, @Nullable ExecutableElement newMethod) {
        ++this.depth;
        if (this.isPotentiallyInApi(oldMethod, newMethod)) {
            this.doVisitMethod(oldMethod, newMethod);
        } else {
            this.dummyRun = true;
        }
    }

    protected void doVisitMethod(@Nullable ExecutableElement oldMethod, @Nullable ExecutableElement newMethod) {
    }

    @Override
    public final void visitMethodParameter(@Nullable VariableElement oldParameter, @Nullable VariableElement newParameter) {
        ++this.depth;
        if (this.isPotentiallyInApi(oldParameter, newParameter)) {
            this.doVisitMethodParameter(oldParameter, newParameter);
        } else {
            this.dummyRun = true;
        }
    }

    protected void doVisitMethodParameter(@Nullable VariableElement oldParameter, @Nullable VariableElement newParameter) {
    }

    @Override
    public final void visitField(@Nullable VariableElement oldField, @Nullable VariableElement newField) {
        ++this.depth;
        if (this.isPotentiallyInApi(oldField, newField)) {
            this.doVisitField(oldField, newField);
        } else {
            this.dummyRun = true;
        }
    }

    protected void doVisitField(@Nullable VariableElement oldField, @Nullable VariableElement newField) {
    }

    @Override
    @Nullable
    public final List<Difference> visitAnnotation(@Nullable AnnotationMirror oldAnnotation, @Nullable AnnotationMirror newAnnotation) {
        ++this.depth;
        List<Difference> ret = this.doVisitAnnotation(oldAnnotation, newAnnotation);
        --this.depth;
        return ret;
    }

    @Nullable
    protected List<Difference> doVisitAnnotation(@Nullable AnnotationMirror oldAnnotation, @Nullable AnnotationMirror newAnnotation) {
        return null;
    }

    protected final <T extends Element> void pushActive(@Nullable T oldElement, @Nullable T newElement, Object ... context) {
        ActiveElements r = new ActiveElements(this.depth, oldElement, newElement, context, null);
        this.activations.push(r);
    }

    @Nullable
    protected <T extends Element> ActiveElements<T> popIfActive() {
        return !this.activations.isEmpty() && ((ActiveElements)this.activations.peek()).depth == this.depth ? this.activations.pop() : null;
    }

    private boolean isPotentiallyInApi(Element oldEl, Element newEl) {
        return !this.oldTypeEnvironment.isExplicitlyExcluded(oldEl) || !this.newTypeEnvironment.isExplicitlyExcluded(newEl);
    }

    protected static class ActiveElements<T extends Element> {
        public final T oldElement;
        public final T newElement;
        public final Object[] context;
        private final int depth;

        private ActiveElements(int depth, T oldElement, T newElement, Object ... context) {
            this.depth = depth;
            this.oldElement = oldElement;
            this.newElement = newElement;
            this.context = context;
        }

        /* synthetic */ ActiveElements(int x0, Element x1, Element x2, Object[] x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }
}

