/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.revapi.API;
import org.revapi.Archive;
import org.revapi.Element;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.AnnotationElement;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.Util;
import org.revapi.simple.SimpleElement;

abstract class JavaElementBase<T extends javax.lang.model.element.Element>
extends SimpleElement
implements JavaModelElement {
    protected final ProbingEnvironment environment;
    protected T element;
    private boolean initializedChildren;
    private final Archive archive;
    private String comparableSignature;

    public JavaElementBase(ProbingEnvironment env, Archive archive, T element) {
        this.environment = env;
        this.element = element;
        this.archive = archive;
    }

    @Nonnull
    protected abstract String getHumanReadableElementType();

    @Nonnull
    public API getApi() {
        return this.environment.getApi();
    }

    @Nullable
    public Archive getArchive() {
        return this.archive;
    }

    public int compareTo(Element o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return JavaElementFactory.compareByType((Element)this, o);
        }
        return this.getComparableSignature().compareTo(((JavaElementBase)o).getComparableSignature());
    }

    @Nonnull
    public TypeEnvironment getTypeEnvironment() {
        return this.environment;
    }

    @Nonnull
    public T getModelElement() {
        return this.element;
    }

    @Nonnull
    public SortedSet<JavaElement> getChildren() {
        if (!this.initializedChildren) {
            SortedSet set = super.getChildren();
            if (this.getModelElement() == null) {
                return set;
            }
            for (javax.lang.model.element.Element element : this.getModelElement().getEnclosedElements()) {
                JavaModelElement child;
                if (element instanceof TypeElement && this.environment.isExplicitlyExcluded(element) || (child = JavaElementFactory.elementFor(element, this.environment, this.archive)) == null) continue;
                child.setParent((Element)this);
                set.add(child);
            }
            for (AnnotationMirror annotationMirror : this.getModelElement().getAnnotationMirrors()) {
                set.add(new AnnotationElement(this.environment, this.archive, annotationMirror));
            }
            this.initializedChildren = true;
        }
        return super.getChildren();
    }

    @Nonnull
    public String getFullHumanReadableString() {
        return this.getHumanReadableElementType() + " " + Util.toHumanReadableString(this.getModelElement());
    }

    public int hashCode() {
        return this.getFullHumanReadableString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj != null && obj instanceof JavaElementBase && this.getFullHumanReadableString().equals(((JavaElementBase)((Object)obj)).getFullHumanReadableString());
    }

    public String toString() {
        return this.getFullHumanReadableString();
    }

    protected String getComparableSignature() {
        if (this.comparableSignature == null) {
            this.comparableSignature = this.createComparableSignature();
        }
        return this.comparableSignature;
    }

    protected abstract String createComparableSignature();
}

