/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.rundeck.api.ApiPathBuilder;
import org.rundeck.api.RundeckApiException;
import org.rundeck.api.RundeckClient;
import org.rundeck.api.parser.ParserHelper;
import org.rundeck.api.parser.XmlNodeParser;
import org.rundeck.api.util.AssertUtil;

class ApiCall {
    private final RundeckClient client;

    public ApiCall(RundeckClient client) throws IllegalArgumentException {
        this.client = client;
        AssertUtil.notNull(client, "The RunDeck Client must not be null !");
    }

    public void ping() throws RundeckApiException {
        HttpClient httpClient = this.instantiateHttpClient();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(this.client.getUrl()));
            if (response.getStatusLine().getStatusCode() / 100 != 2) {
                throw new RundeckApiException("Invalid HTTP response '" + response.getStatusLine() + "' when pinging " + this.client.getUrl());
            }
        }
        catch (IOException e) {
            throw new RundeckApiException("Failed to ping RunDeck instance at " + this.client.getUrl(), e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCredentials() throws RundeckApiException.RundeckApiLoginException {
        HttpClient httpClient = this.instantiateHttpClient();
        try {
            this.login(httpClient);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public <T> T get(ApiPathBuilder apiPath, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        return this.execute((HttpRequestBase)new HttpGet(this.client.getUrl() + "/api/1" + apiPath), parser);
    }

    public InputStream get(ApiPathBuilder apiPath) throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        ByteArrayInputStream response = this.execute((HttpRequestBase)new HttpGet(this.client.getUrl() + "/api/1" + apiPath));
        ParserHelper.loadDocument(response);
        response.reset();
        return response;
    }

    public <T> T post(ApiPathBuilder apiPath, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        HttpPost httpPost = new HttpPost(this.client.getUrl() + "/api/1" + apiPath);
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry<String, InputStream> attachment : apiPath.getAttachments().entrySet()) {
            entity.addPart(attachment.getKey(), (ContentBody)new InputStreamBody(attachment.getValue(), attachment.getKey()));
        }
        httpPost.setEntity((HttpEntity)entity);
        return this.execute((HttpRequestBase)httpPost, parser);
    }

    public <T> T delete(ApiPathBuilder apiPath, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        return this.execute((HttpRequestBase)new HttpDelete(this.client.getUrl() + "/api/1" + apiPath), parser);
    }

    private <T> T execute(HttpRequestBase request, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        ByteArrayInputStream response = this.execute(request);
        Document xmlDocument = ParserHelper.loadDocument(response);
        return parser.parseXmlNode((Node)xmlDocument);
    }

    private ByteArrayInputStream execute(HttpRequestBase request) throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        HttpClient httpClient = this.instantiateHttpClient();
        try {
            Object newLocation;
            this.login(httpClient);
            HttpResponse response = null;
            try {
                response = httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new RundeckApiException("Failed to execute an HTTP " + request.getMethod() + " on url : " + request.getURI(), e);
            }
            if (response.getStatusLine().getStatusCode() / 100 == 3 && "DELETE".equals(request.getMethod())) {
                newLocation = response.getFirstHeader("Location").getValue();
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    throw new RundeckApiException("Failed to consume entity (release connection)", e);
                }
                request = new HttpDelete((String)newLocation);
                try {
                    response = httpClient.execute((HttpUriRequest)request);
                }
                catch (IOException e) {
                    throw new RundeckApiException("Failed to execute an HTTP " + request.getMethod() + " on url : " + request.getURI(), e);
                }
            }
            if (response.getStatusLine().getStatusCode() / 100 == 3) {
                newLocation = response.getFirstHeader("Location").getValue();
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    throw new RundeckApiException("Failed to consume entity (release connection)", e);
                }
                request = new HttpGet((String)newLocation);
                try {
                    response = httpClient.execute((HttpUriRequest)request);
                }
                catch (IOException e) {
                    throw new RundeckApiException("Failed to execute an HTTP GET on url : " + request.getURI(), e);
                }
            }
            if (response.getStatusLine().getStatusCode() / 100 != 2) {
                throw new RundeckApiException("Invalid HTTP response '" + response.getStatusLine() + "' for " + request.getURI());
            }
            if (response.getEntity() == null) {
                throw new RundeckApiException("Empty RunDeck response ! HTTP status line is : " + response.getStatusLine());
            }
            try {
                newLocation = new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
                return newLocation;
            }
            catch (IOException e) {
                throw new RundeckApiException("Failed to consume entity and convert the inputStream", e);
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private void login(HttpClient httpClient) throws RundeckApiException.RundeckApiLoginException {
        HttpResponse response;
        String location = this.client.getUrl() + "/j_security_check";
        while (true) {
            HttpPost postLogin = new HttpPost(location);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("j_username", this.client.getLogin()));
            params.add(new BasicNameValuePair("j_password", this.client.getPassword()));
            params.add(new BasicNameValuePair("action", "login"));
            response = null;
            try {
                postLogin.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                response = httpClient.execute((HttpUriRequest)postLogin);
            }
            catch (IOException e) {
                throw new RundeckApiException.RundeckApiLoginException("Failed to post login form on " + location, e);
            }
            if (response.getStatusLine().getStatusCode() / 100 != 3) break;
            location = response.getFirstHeader("Location").getValue();
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                throw new RundeckApiException.RundeckApiLoginException("Failed to consume entity (release connection)", e);
            }
        }
        if (response.getStatusLine().getStatusCode() / 100 != 2) {
            throw new RundeckApiException.RundeckApiLoginException("Invalid HTTP response '" + response.getStatusLine() + "' for " + location);
        }
        try {
            String content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (StringUtils.contains((String)content, (String)"j_security_check")) {
                throw new RundeckApiException.RundeckApiLoginException("Login failed for user " + this.client.getLogin());
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                throw new RundeckApiException.RundeckApiLoginException("Failed to consume entity (release connection)", e);
            }
        }
        catch (IOException io) {
            throw new RundeckApiException.RundeckApiLoginException("Failed to read RunDeck result", io);
        }
        catch (ParseException p) {
            throw new RundeckApiException.RundeckApiLoginException("Failed to parse RunDeck response", p);
        }
    }

    private HttpClient instantiateHttpClient() {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        SSLSocketFactory socketFactory = null;
        try {
            socketFactory = new SSLSocketFactory(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
        System.setProperty("java.net.useSystemProxies", "true");
        httpClient.setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(httpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault()));
        return httpClient;
    }
}

