/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.rundeck.api.util.ParametersUtil;

class ApiPathBuilder {
    private final StringBuilder apiPath = new StringBuilder();
    private final Map<String, InputStream> attachments = new HashMap<String, InputStream>();
    private boolean firstParamDone = false;

    public ApiPathBuilder(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                if (!StringUtils.isNotBlank((String)path)) continue;
                this.append(path);
            }
        }
    }

    public ApiPathBuilder param(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.appendSeparator();
            this.append(key);
            this.append("=");
            this.append(ParametersUtil.urlEncode(value));
        }
        return this;
    }

    public ApiPathBuilder param(String key, Enum<?> value) {
        if (value != null) {
            this.param(key, StringUtils.lowerCase((String)value.toString()));
        }
        return this;
    }

    public ApiPathBuilder param(String key, Date value) {
        if (value != null) {
            this.param(key, value.getTime());
        }
        return this;
    }

    public ApiPathBuilder param(String key, Long value) {
        if (value != null) {
            this.param(key, value.toString());
        }
        return this;
    }

    public ApiPathBuilder param(String key, Integer value) {
        if (value != null) {
            this.param(key, value.toString());
        }
        return this;
    }

    public ApiPathBuilder param(String key, Boolean value) {
        if (value != null) {
            this.param(key, value.toString());
        }
        return this;
    }

    public ApiPathBuilder nodeFilters(Properties nodeFilters) {
        String filters = ParametersUtil.generateNodeFiltersString(nodeFilters);
        if (StringUtils.isNotBlank((String)filters)) {
            this.appendSeparator();
            this.append(filters);
        }
        return this;
    }

    public ApiPathBuilder attach(String name, InputStream stream) {
        if (stream != null) {
            this.attachments.put(name, stream);
        }
        return this;
    }

    public Map<String, InputStream> getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return this.apiPath.toString();
    }

    private void append(String str) {
        this.apiPath.append(str);
    }

    private void appendSeparator() {
        if (this.firstParamDone) {
            this.append("&");
        } else {
            this.append("?");
            this.firstParamDone = true;
        }
    }
}

