/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.rundeck.api.ApiCall;
import org.rundeck.api.ApiPathBuilder;
import org.rundeck.api.FileType;
import org.rundeck.api.RundeckApiException;
import org.rundeck.api.domain.RundeckAbort;
import org.rundeck.api.domain.RundeckExecution;
import org.rundeck.api.domain.RundeckHistory;
import org.rundeck.api.domain.RundeckJob;
import org.rundeck.api.domain.RundeckJobsImportMethod;
import org.rundeck.api.domain.RundeckJobsImportResult;
import org.rundeck.api.domain.RundeckNode;
import org.rundeck.api.domain.RundeckProject;
import org.rundeck.api.domain.RundeckSystemInfo;
import org.rundeck.api.parser.AbortParser;
import org.rundeck.api.parser.ExecutionParser;
import org.rundeck.api.parser.HistoryParser;
import org.rundeck.api.parser.JobParser;
import org.rundeck.api.parser.JobsImportResultParser;
import org.rundeck.api.parser.ListParser;
import org.rundeck.api.parser.NodeParser;
import org.rundeck.api.parser.ProjectParser;
import org.rundeck.api.parser.StringParser;
import org.rundeck.api.parser.SystemInfoParser;
import org.rundeck.api.util.AssertUtil;
import org.rundeck.api.util.ParametersUtil;

public class RundeckClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final transient int API_VERSION = 1;
    public static final transient String API_ENDPOINT = "/api/1";
    private static final transient long DEFAULT_POOLING_INTERVAL = 5L;
    private static final transient TimeUnit DEFAULT_POOLING_UNIT = TimeUnit.SECONDS;
    private final String url;
    private final String login;
    private final String password;

    public RundeckClient(String url, String login, String password) throws IllegalArgumentException {
        this.url = url;
        this.login = login;
        this.password = password;
        AssertUtil.notBlank(url, "The RunDeck URL is mandatory !");
        AssertUtil.notBlank(login, "The RunDeck login is mandatory !");
        AssertUtil.notBlank(password, "The RunDeck password is mandatory !");
    }

    public void ping() throws RundeckApiException {
        new ApiCall(this).ping();
    }

    public void testCredentials() throws RundeckApiException.RundeckApiLoginException {
        new ApiCall(this).testCredentials();
    }

    public List<RundeckProject> getProjects() throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/projects"), new ListParser<RundeckProject>(new ProjectParser(), "result/projects/project")));
    }

    public RundeckProject getProject(String projectName) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to get the details of a project !");
        return new ApiCall(this).get(new ApiPathBuilder("/project/", projectName), new ProjectParser("result/projects/project"));
    }

    public List<RundeckJob> getJobs() throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        ArrayList<RundeckJob> jobs = new ArrayList<RundeckJob>();
        for (RundeckProject project : this.getProjects()) {
            jobs.addAll(this.getJobs(project.getName()));
        }
        return jobs;
    }

    public List<RundeckJob> getJobs(String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getJobs(project, null, null, new String[0]);
    }

    public List<RundeckJob> getJobs(String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to get all jobs !");
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/jobs").param("project", project).param("jobFilter", jobFilter).param("groupPath", groupPath).param("idlist", StringUtils.join((Object[])jobIds, (String)",")), new ListParser<RundeckJob>(new JobParser(), "result/jobs/job")));
    }

    public void exportJobsToFile(String filename, String format, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(format, "format is mandatory to export jobs !");
        this.exportJobsToFile(filename, FileType.valueOf(StringUtils.upperCase((String)format)), project);
    }

    public void exportJobsToFile(String filename, FileType format, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        this.exportJobsToFile(filename, format, project, null, null, new String[0]);
    }

    public void exportJobsToFile(String filename, String format, String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(format, "format is mandatory to export jobs !");
        this.exportJobsToFile(filename, FileType.valueOf(StringUtils.upperCase((String)format)), project, jobFilter, groupPath, jobIds);
    }

    public void exportJobsToFile(String filename, FileType format, String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(filename, "filename is mandatory to export a job !");
        InputStream inputStream = this.exportJobs(format, project, jobFilter, groupPath, jobIds);
        FileUtils.writeByteArrayToFile((File)new File(filename), (byte[])IOUtils.toByteArray((InputStream)inputStream));
    }

    public InputStream exportJobs(String format, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(format, "format is mandatory to export jobs !");
        return this.exportJobs(FileType.valueOf(StringUtils.upperCase((String)format)), project);
    }

    public InputStream exportJobs(FileType format, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.exportJobs(format, project, null, null, new String[0]);
    }

    public InputStream exportJobs(String format, String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(format, "format is mandatory to export jobs !");
        return this.exportJobs(FileType.valueOf(StringUtils.upperCase((String)format)), project, jobFilter, groupPath, jobIds);
    }

    public InputStream exportJobs(FileType format, String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notNull((Object)format, "format is mandatory to export jobs !");
        AssertUtil.notBlank(project, "project is mandatory to export jobs !");
        return new ApiCall(this).get(new ApiPathBuilder("/jobs/export").param("format", format).param("project", project).param("jobFilter", jobFilter).param("groupPath", groupPath).param("idlist", StringUtils.join((Object[])jobIds, (String)",")));
    }

    public void exportJobToFile(String filename, String format, String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(format, "format is mandatory to export a job !");
        this.exportJobToFile(filename, FileType.valueOf(StringUtils.upperCase((String)format)), jobId);
    }

    public void exportJobToFile(String filename, FileType format, String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(filename, "filename is mandatory to export a job !");
        InputStream inputStream = this.exportJob(format, jobId);
        FileUtils.writeByteArrayToFile((File)new File(filename), (byte[])IOUtils.toByteArray((InputStream)inputStream));
    }

    public InputStream exportJob(String format, String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(format, "format is mandatory to export a job !");
        return this.exportJob(FileType.valueOf(StringUtils.upperCase((String)format)), jobId);
    }

    public InputStream exportJob(FileType format, String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notNull((Object)format, "format is mandatory to export a job !");
        AssertUtil.notBlank(jobId, "jobId is mandatory to export a job !");
        return new ApiCall(this).get(new ApiPathBuilder("/job/", jobId).param("format", format));
    }

    public RundeckJobsImportResult importJobs(String filename, String fileType) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(fileType, "fileType is mandatory to import jobs !");
        return this.importJobs(filename, FileType.valueOf(StringUtils.upperCase((String)fileType)));
    }

    public RundeckJobsImportResult importJobs(String filename, FileType fileType) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.importJobs(filename, fileType, (RundeckJobsImportMethod)null);
    }

    public RundeckJobsImportResult importJobs(String filename, String fileType, String importBehavior) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(fileType, "fileType is mandatory to import jobs !");
        return this.importJobs(filename, FileType.valueOf(StringUtils.upperCase((String)fileType)), RundeckJobsImportMethod.valueOf(StringUtils.upperCase((String)importBehavior)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RundeckJobsImportResult importJobs(String filename, FileType fileType, RundeckJobsImportMethod importBehavior) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        RundeckJobsImportResult rundeckJobsImportResult;
        AssertUtil.notBlank(filename, "filename (of jobs file) is mandatory to import jobs !");
        FileInputStream stream = null;
        try {
            stream = FileUtils.openInputStream((File)new File(filename));
            rundeckJobsImportResult = this.importJobs((InputStream)stream, fileType, importBehavior);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return rundeckJobsImportResult;
    }

    public RundeckJobsImportResult importJobs(InputStream stream, String fileType) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(fileType, "fileType is mandatory to import jobs !");
        return this.importJobs(stream, FileType.valueOf(StringUtils.upperCase((String)fileType)));
    }

    public RundeckJobsImportResult importJobs(InputStream stream, FileType fileType) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.importJobs(stream, fileType, (RundeckJobsImportMethod)null);
    }

    public RundeckJobsImportResult importJobs(InputStream stream, String fileType, String importBehavior) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(fileType, "fileType is mandatory to import jobs !");
        return this.importJobs(stream, FileType.valueOf(StringUtils.upperCase((String)fileType)), RundeckJobsImportMethod.valueOf(StringUtils.upperCase((String)importBehavior)));
    }

    public RundeckJobsImportResult importJobs(InputStream stream, FileType fileType, RundeckJobsImportMethod importBehavior) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notNull(stream, "inputStream of jobs is mandatory to import jobs !");
        AssertUtil.notNull((Object)fileType, "fileType is mandatory to import jobs !");
        return new ApiCall(this).post(new ApiPathBuilder("/jobs/import").param("format", fileType).param("dupeOption", importBehavior).attach("xmlBatch", stream), new JobsImportResultParser("result"));
    }

    public RundeckJob findJob(String project, String groupPath, String name) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to find a job !");
        AssertUtil.notBlank(name, "job name is mandatory to find a job !");
        List<RundeckJob> jobs = this.getJobs(project, name, groupPath, new String[0]);
        return jobs.isEmpty() ? null : jobs.get(0);
    }

    public RundeckJob getJob(String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(jobId, "jobId is mandatory to get the details of a job !");
        return new ApiCall(this).get(new ApiPathBuilder("/job/", jobId), new JobParser("joblist/job"));
    }

    public String deleteJob(String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(jobId, "jobId is mandatory to delete a job !");
        return new ApiCall(this).delete(new ApiPathBuilder("/job/", jobId), new StringParser("result/success/message"));
    }

    public RundeckExecution triggerJob(String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.triggerJob(jobId, null);
    }

    public RundeckExecution triggerJob(String jobId, Properties options) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.triggerJob(jobId, options, null);
    }

    public RundeckExecution triggerJob(String jobId, Properties options, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(jobId, "jobId is mandatory to trigger a job !");
        return new ApiCall(this).get(new ApiPathBuilder("/job/", jobId, "/run").param("argString", ParametersUtil.generateArgString(options)).nodeFilters(nodeFilters), new ExecutionParser("result/executions/execution"));
    }

    public RundeckExecution runJob(String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.runJob(jobId, null);
    }

    public RundeckExecution runJob(String jobId, Properties options) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.runJob(jobId, options, null);
    }

    public RundeckExecution runJob(String jobId, Properties options, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.runJob(jobId, options, nodeFilters, 5L, DEFAULT_POOLING_UNIT);
    }

    public RundeckExecution runJob(String jobId, Properties options, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.runJob(jobId, options, null, poolingInterval, poolingUnit);
    }

    public RundeckExecution runJob(String jobId, Properties options, Properties nodeFilters, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        if (poolingInterval <= 0L) {
            poolingInterval = 5L;
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        if (poolingUnit == null) {
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        RundeckExecution execution = this.triggerJob(jobId, options, nodeFilters);
        while (RundeckExecution.ExecutionStatus.RUNNING.equals((Object)execution.getStatus())) {
            try {
                Thread.sleep(poolingUnit.toMillis(poolingInterval));
            }
            catch (InterruptedException e) {
                break;
            }
            execution = this.getExecution(execution.getId());
        }
        return execution;
    }

    public RundeckExecution triggerAdhocCommand(String project, String command) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.triggerAdhocCommand(project, command, null);
    }

    public RundeckExecution triggerAdhocCommand(String project, String command, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.triggerAdhocCommand(project, command, nodeFilters, null, null);
    }

    public RundeckExecution triggerAdhocCommand(String project, String command, Properties nodeFilters, Integer nodeThreadcount, Boolean nodeKeepgoing) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to trigger an ad-hoc command !");
        AssertUtil.notBlank(command, "command is mandatory to trigger an ad-hoc command !");
        RundeckExecution execution = new ApiCall(this).get(new ApiPathBuilder("/run/command").param("project", project).param("exec", command).param("nodeThreadcount", nodeThreadcount).param("nodeKeepgoing", nodeKeepgoing).nodeFilters(nodeFilters), new ExecutionParser("result/execution"));
        return this.getExecution(execution.getId());
    }

    public RundeckExecution runAdhocCommand(String project, String command) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.runAdhocCommand(project, command, null);
    }

    public RundeckExecution runAdhocCommand(String project, String command, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.runAdhocCommand(project, command, null, poolingInterval, poolingUnit);
    }

    public RundeckExecution runAdhocCommand(String project, String command, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.runAdhocCommand(project, command, nodeFilters, null, null);
    }

    public RundeckExecution runAdhocCommand(String project, String command, Properties nodeFilters, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.runAdhocCommand(project, command, nodeFilters, null, null, poolingInterval, poolingUnit);
    }

    public RundeckExecution runAdhocCommand(String project, String command, Properties nodeFilters, Integer nodeThreadcount, Boolean nodeKeepgoing) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.runAdhocCommand(project, command, nodeFilters, nodeThreadcount, nodeKeepgoing, 5L, DEFAULT_POOLING_UNIT);
    }

    public RundeckExecution runAdhocCommand(String project, String command, Properties nodeFilters, Integer nodeThreadcount, Boolean nodeKeepgoing, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        if (poolingInterval <= 0L) {
            poolingInterval = 5L;
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        if (poolingUnit == null) {
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        RundeckExecution execution = this.triggerAdhocCommand(project, command, nodeFilters, nodeThreadcount, nodeKeepgoing);
        while (RundeckExecution.ExecutionStatus.RUNNING.equals((Object)execution.getStatus())) {
            try {
                Thread.sleep(poolingUnit.toMillis(poolingInterval));
            }
            catch (InterruptedException e) {
                break;
            }
            execution = this.getExecution(execution.getId());
        }
        return execution;
    }

    public RundeckExecution triggerAdhocScript(String project, String scriptFilename) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.triggerAdhocScript(project, scriptFilename, null);
    }

    public RundeckExecution triggerAdhocScript(String project, String scriptFilename, Properties options) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.triggerAdhocScript(project, scriptFilename, options, null);
    }

    public RundeckExecution triggerAdhocScript(String project, String scriptFilename, Properties options, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.triggerAdhocScript(project, scriptFilename, options, nodeFilters, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RundeckExecution triggerAdhocScript(String project, String scriptFilename, Properties options, Properties nodeFilters, Integer nodeThreadcount, Boolean nodeKeepgoing) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        RundeckExecution rundeckExecution;
        AssertUtil.notBlank(scriptFilename, "scriptFilename is mandatory to trigger an ad-hoc script !");
        FileInputStream stream = null;
        try {
            stream = FileUtils.openInputStream((File)new File(scriptFilename));
            rundeckExecution = this.triggerAdhocScript(project, stream, options, nodeFilters, nodeThreadcount, nodeKeepgoing);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return rundeckExecution;
    }

    public RundeckExecution triggerAdhocScript(String project, InputStream script) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.triggerAdhocScript(project, script, null);
    }

    public RundeckExecution triggerAdhocScript(String project, InputStream script, Properties options) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.triggerAdhocScript(project, script, options, null);
    }

    public RundeckExecution triggerAdhocScript(String project, InputStream script, Properties options, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.triggerAdhocScript(project, script, options, nodeFilters, null, null);
    }

    public RundeckExecution triggerAdhocScript(String project, InputStream script, Properties options, Properties nodeFilters, Integer nodeThreadcount, Boolean nodeKeepgoing) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to trigger an ad-hoc script !");
        AssertUtil.notNull(script, "script is mandatory to trigger an ad-hoc script !");
        RundeckExecution execution = new ApiCall(this).post(new ApiPathBuilder("/run/script").param("project", project).attach("scriptFile", script).param("argString", ParametersUtil.generateArgString(options)).param("nodeThreadcount", nodeThreadcount).param("nodeKeepgoing", nodeKeepgoing).nodeFilters(nodeFilters), new ExecutionParser("result/execution"));
        return this.getExecution(execution.getId());
    }

    public RundeckExecution runAdhocScript(String project, String scriptFilename) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, scriptFilename, null);
    }

    public RundeckExecution runAdhocScript(String project, String scriptFilename, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, scriptFilename, null, poolingInterval, poolingUnit);
    }

    public RundeckExecution runAdhocScript(String project, String scriptFilename, Properties options) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, scriptFilename, options, null);
    }

    public RundeckExecution runAdhocScript(String project, String scriptFilename, Properties options, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, scriptFilename, options, null, poolingInterval, poolingUnit);
    }

    public RundeckExecution runAdhocScript(String project, String scriptFilename, Properties options, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, scriptFilename, options, nodeFilters, null, null);
    }

    public RundeckExecution runAdhocScript(String project, String scriptFilename, Properties options, Properties nodeFilters, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, scriptFilename, options, nodeFilters, null, null, poolingInterval, poolingUnit);
    }

    public RundeckExecution runAdhocScript(String project, String scriptFilename, Properties options, Properties nodeFilters, Integer nodeThreadcount, Boolean nodeKeepgoing) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, scriptFilename, options, nodeFilters, nodeThreadcount, nodeKeepgoing, 5L, DEFAULT_POOLING_UNIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RundeckExecution runAdhocScript(String project, String scriptFilename, Properties options, Properties nodeFilters, Integer nodeThreadcount, Boolean nodeKeepgoing, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        RundeckExecution rundeckExecution;
        AssertUtil.notBlank(scriptFilename, "scriptFilename is mandatory to run an ad-hoc script !");
        FileInputStream stream = null;
        try {
            stream = FileUtils.openInputStream((File)new File(scriptFilename));
            rundeckExecution = this.runAdhocScript(project, stream, options, nodeFilters, nodeThreadcount, nodeKeepgoing, poolingInterval, poolingUnit);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return rundeckExecution;
    }

    public RundeckExecution runAdhocScript(String project, InputStream script) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, script, null);
    }

    public RundeckExecution runAdhocScript(String project, InputStream script, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, script, null, poolingInterval, poolingUnit);
    }

    public RundeckExecution runAdhocScript(String project, InputStream script, Properties options) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, script, options, null);
    }

    public RundeckExecution runAdhocScript(String project, InputStream script, Properties options, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, script, options, null, poolingInterval, poolingUnit);
    }

    public RundeckExecution runAdhocScript(String project, InputStream script, Properties options, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, script, options, nodeFilters, null, null);
    }

    public RundeckExecution runAdhocScript(String project, InputStream script, Properties options, Properties nodeFilters, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, script, options, nodeFilters, null, null, poolingInterval, poolingUnit);
    }

    public RundeckExecution runAdhocScript(String project, InputStream script, Properties options, Properties nodeFilters, Integer nodeThreadcount, Boolean nodeKeepgoing) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException, IOException {
        return this.runAdhocScript(project, script, options, nodeFilters, nodeThreadcount, nodeKeepgoing, 5L, DEFAULT_POOLING_UNIT);
    }

    public RundeckExecution runAdhocScript(String project, InputStream script, Properties options, Properties nodeFilters, Integer nodeThreadcount, Boolean nodeKeepgoing, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        if (poolingInterval <= 0L) {
            poolingInterval = 5L;
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        if (poolingUnit == null) {
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        RundeckExecution execution = this.triggerAdhocScript(project, script, options, nodeFilters, nodeThreadcount, nodeKeepgoing);
        while (RundeckExecution.ExecutionStatus.RUNNING.equals((Object)execution.getStatus())) {
            try {
                Thread.sleep(poolingUnit.toMillis(poolingInterval));
            }
            catch (InterruptedException e) {
                break;
            }
            execution = this.getExecution(execution.getId());
        }
        return execution;
    }

    public List<RundeckExecution> getRunningExecutions() throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        ArrayList<RundeckExecution> executions = new ArrayList<RundeckExecution>();
        for (RundeckProject project : this.getProjects()) {
            executions.addAll(this.getRunningExecutions(project.getName()));
        }
        return executions;
    }

    public List<RundeckExecution> getRunningExecutions(String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory get all running executions !");
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/executions/running").param("project", project), new ListParser<RundeckExecution>(new ExecutionParser(), "result/executions/execution")));
    }

    public List<RundeckExecution> getJobExecutions(String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getJobExecutions(jobId, (RundeckExecution.ExecutionStatus)null);
    }

    public List<RundeckExecution> getJobExecutions(String jobId, String status) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getJobExecutions(jobId, StringUtils.isBlank((String)status) ? null : RundeckExecution.ExecutionStatus.valueOf(StringUtils.upperCase((String)status)));
    }

    public List<RundeckExecution> getJobExecutions(String jobId, RundeckExecution.ExecutionStatus status) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getJobExecutions(jobId, status, null, null);
    }

    public List<RundeckExecution> getJobExecutions(String jobId, String status, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getJobExecutions(jobId, StringUtils.isBlank((String)status) ? null : RundeckExecution.ExecutionStatus.valueOf(StringUtils.upperCase((String)status)), max, offset);
    }

    public List<RundeckExecution> getJobExecutions(String jobId, RundeckExecution.ExecutionStatus status, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(jobId, "jobId is mandatory to get the executions of a job !");
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/job/", jobId, "/executions").param("status", status).param("max", max).param("offset", offset), new ListParser<RundeckExecution>(new ExecutionParser(), "result/executions/execution")));
    }

    public RundeckExecution getExecution(Long executionId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to get the details of an execution !");
        return new ApiCall(this).get(new ApiPathBuilder("/execution/", executionId.toString()), new ExecutionParser("result/executions/execution"));
    }

    public RundeckAbort abortExecution(Long executionId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to abort an execution !");
        return new ApiCall(this).get(new ApiPathBuilder("/execution/", executionId.toString(), "/abort"), new AbortParser("result/abort"));
    }

    public RundeckHistory getHistory(String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getHistory(project, null, null, null, null, null, null, null, null);
    }

    public RundeckHistory getHistory(String project, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getHistory(project, null, null, null, null, null, null, max, offset);
    }

    public RundeckHistory getHistory(String project, String jobId, String reportId, String user) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getHistory(project, jobId, reportId, user, null, null, null, null, null);
    }

    public RundeckHistory getHistory(String project, String jobId, String reportId, String user, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getHistory(project, jobId, reportId, user, null, null, null, max, offset);
    }

    public RundeckHistory getHistory(String project, String recent) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getHistory(project, null, null, null, recent, null, null, null, null);
    }

    public RundeckHistory getHistory(String project, String recent, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getHistory(project, null, null, null, recent, null, null, max, offset);
    }

    public RundeckHistory getHistory(String project, Date begin, Date end) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getHistory(project, null, null, null, null, begin, end, null, null);
    }

    public RundeckHistory getHistory(String project, Date begin, Date end, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getHistory(project, null, null, null, null, begin, end, max, offset);
    }

    public RundeckHistory getHistory(String project, String jobId, String reportId, String user, String recent, Date begin, Date end, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to get the history !");
        return new ApiCall(this).get(new ApiPathBuilder("/history").param("project", project).param("jobIdFilter", jobId).param("reportIdFilter", reportId).param("userFilter", user).param("recentFilter", recent).param("begin", begin).param("end", end).param("max", max).param("offset", offset), new HistoryParser("result/events"));
    }

    public List<RundeckNode> getNodes() throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        ArrayList<RundeckNode> nodes = new ArrayList<RundeckNode>();
        for (RundeckProject project : this.getProjects()) {
            nodes.addAll(this.getNodes(project.getName()));
        }
        return nodes;
    }

    public List<RundeckNode> getNodes(String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        return this.getNodes(project, null);
    }

    public List<RundeckNode> getNodes(String project, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to get all nodes !");
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/resources").param("project", project).nodeFilters(nodeFilters), new ListParser<RundeckNode>(new NodeParser(), "project/node")));
    }

    public RundeckNode getNode(String name, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, IllegalArgumentException {
        AssertUtil.notBlank(name, "the name of the node is mandatory to get a node !");
        AssertUtil.notBlank(project, "project is mandatory to get a node !");
        return new ApiCall(this).get(new ApiPathBuilder("/resource/", name).param("project", project), new NodeParser("project/node"));
    }

    public RundeckSystemInfo getSystemInfo() throws RundeckApiException, RundeckApiException.RundeckApiLoginException {
        return new ApiCall(this).get(new ApiPathBuilder("/system/info"), new SystemInfoParser("result/system"));
    }

    public String getUrl() {
        return this.url;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "RundeckClient 1 [" + this.url + "] (credentials=" + this.login + "|" + this.password + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RundeckClient other = (RundeckClient)obj;
        if (this.login == null ? other.login != null : !this.login.equals(other.login)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

