/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DurationFormatUtils;

public class RundeckEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title;
    private EventStatus status;
    private String summary;
    private NodeSummary nodeSummary;
    private String user;
    private String project;
    private Date startedAt;
    private Date endedAt;
    private String abortedBy;
    private Long executionId;
    private String jobId;

    public Long getDurationInMillis() {
        if (this.startedAt == null || this.endedAt == null) {
            return null;
        }
        return this.endedAt.getTime() - this.startedAt.getTime();
    }

    public Long getDurationInSeconds() {
        Long durationInMillis = this.getDurationInMillis();
        return durationInMillis != null ? Long.valueOf(TimeUnit.MILLISECONDS.toSeconds(durationInMillis)) : null;
    }

    public String getDuration() {
        Long durationInMillis = this.getDurationInMillis();
        return durationInMillis != null ? DurationFormatUtils.formatDurationWords((long)durationInMillis, (boolean)true, (boolean)true) : null;
    }

    public String getShortDuration() {
        Long durationInMillis = this.getDurationInMillis();
        return durationInMillis != null ? DurationFormatUtils.formatDurationHMS((long)durationInMillis) : null;
    }

    public boolean isAdhoc() {
        return "adhoc".equals(this.title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public EventStatus getStatus() {
        return this.status;
    }

    public void setStatus(EventStatus status) {
        this.status = status;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public NodeSummary getNodeSummary() {
        return this.nodeSummary;
    }

    public void setNodeSummary(NodeSummary nodeSummary) {
        this.nodeSummary = nodeSummary;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public Date getStartedAt() {
        return this.startedAt != null ? new Date(this.startedAt.getTime()) : null;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt != null ? new Date(startedAt.getTime()) : null;
    }

    public Date getEndedAt() {
        return this.endedAt != null ? new Date(this.endedAt.getTime()) : null;
    }

    public void setEndedAt(Date endedAt) {
        this.endedAt = endedAt != null ? new Date(endedAt.getTime()) : null;
    }

    public String getAbortedBy() {
        return this.abortedBy;
    }

    public void setAbortedBy(String abortedBy) {
        this.abortedBy = abortedBy;
    }

    public Long getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(Long executionId) {
        this.executionId = executionId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String toString() {
        return "RundeckEvent [abortedBy=" + this.abortedBy + ", endedAt=" + this.endedAt + ", executionId=" + this.executionId + ", jobId=" + this.jobId + ", nodeSummary=" + this.nodeSummary + ", project=" + this.project + ", startedAt=" + this.startedAt + ", status=" + (Object)((Object)this.status) + ", summary=" + this.summary + ", title=" + this.title + ", user=" + this.user + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abortedBy == null ? 0 : this.abortedBy.hashCode());
        result = 31 * result + (this.endedAt == null ? 0 : this.endedAt.hashCode());
        result = 31 * result + (this.executionId == null ? 0 : this.executionId.hashCode());
        result = 31 * result + (this.jobId == null ? 0 : this.jobId.hashCode());
        result = 31 * result + (this.nodeSummary == null ? 0 : this.nodeSummary.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.startedAt == null ? 0 : this.startedAt.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.summary == null ? 0 : this.summary.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RundeckEvent other = (RundeckEvent)obj;
        if (this.abortedBy == null ? other.abortedBy != null : !this.abortedBy.equals(other.abortedBy)) {
            return false;
        }
        if (this.endedAt == null ? other.endedAt != null : !this.endedAt.equals(other.endedAt)) {
            return false;
        }
        if (this.executionId == null ? other.executionId != null : !this.executionId.equals(other.executionId)) {
            return false;
        }
        if (this.jobId == null ? other.jobId != null : !this.jobId.equals(other.jobId)) {
            return false;
        }
        if (this.nodeSummary == null ? other.nodeSummary != null : !this.nodeSummary.equals(other.nodeSummary)) {
            return false;
        }
        if (this.project == null ? other.project != null : !this.project.equals(other.project)) {
            return false;
        }
        if (this.startedAt == null ? other.startedAt != null : !this.startedAt.equals(other.startedAt)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.summary == null ? other.summary != null : !this.summary.equals(other.summary)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public static enum EventStatus {
        SUCCEEDED,
        FAILED,
        ABORTED;

    }

    public static class NodeSummary
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int succeeded;
        private int failed;
        private int total;

        public int getSucceeded() {
            return this.succeeded;
        }

        public void setSucceeded(int succeeded) {
            this.succeeded = succeeded;
        }

        public int getFailed() {
            return this.failed;
        }

        public void setFailed(int failed) {
            this.failed = failed;
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public String toString() {
            return "NodeSummary [succeeded=" + this.succeeded + ", failed=" + this.failed + ", total=" + this.total + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.failed;
            result = 31 * result + this.succeeded;
            result = 31 * result + this.total;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeSummary other = (NodeSummary)obj;
            if (this.failed != other.failed) {
                return false;
            }
            if (this.succeeded != other.succeeded) {
                return false;
            }
            return this.total == other.total;
        }
    }
}

