/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckJob;
import org.rundeck.api.parser.XmlNodeParser;

public class JobParser
implements XmlNodeParser<RundeckJob> {
    private String xpath;

    public JobParser() {
    }

    public JobParser(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public RundeckJob parseXmlNode(Node node) {
        Node jobNode = this.xpath != null ? node.selectSingleNode(this.xpath) : node;
        RundeckJob job = new RundeckJob();
        job.setName(StringUtils.trimToNull((String)jobNode.valueOf("name")));
        job.setDescription(StringUtils.trimToNull((String)jobNode.valueOf("description")));
        job.setGroup(StringUtils.trimToNull((String)jobNode.valueOf("group")));
        String jobId = null;
        jobId = jobNode.valueOf("id");
        if (StringUtils.isBlank((String)jobId)) {
            jobId = jobNode.valueOf("@id");
        }
        job.setId(jobId);
        Node contextNode = jobNode.selectSingleNode("context");
        if (contextNode != null) {
            job.setProject(StringUtils.trimToNull((String)contextNode.valueOf("project")));
        } else {
            job.setProject(StringUtils.trimToNull((String)jobNode.valueOf("project")));
        }
        return job;
    }
}

