/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.List;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckJob;
import org.rundeck.api.domain.RundeckJobsImportResult;
import org.rundeck.api.parser.JobParser;
import org.rundeck.api.parser.XmlNodeParser;

public class JobsImportResultParser
implements XmlNodeParser<RundeckJobsImportResult> {
    private String xpath;

    public JobsImportResultParser() {
    }

    public JobsImportResultParser(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public RundeckJobsImportResult parseXmlNode(Node node) {
        List failedJobsNodes;
        List skippedJobsNodes;
        Node resultNode = this.xpath != null ? node.selectSingleNode(this.xpath) : node;
        RundeckJobsImportResult result = new RundeckJobsImportResult();
        List succeededJobsNodes = resultNode.selectNodes("succeeded/job");
        if (succeededJobsNodes != null) {
            for (Node succeededJobNode : succeededJobsNodes) {
                RundeckJob job = new JobParser().parseXmlNode(succeededJobNode);
                result.addSucceededJob(job);
            }
        }
        if ((skippedJobsNodes = resultNode.selectNodes("skipped/job")) != null) {
            for (Node skippedJobNode : skippedJobsNodes) {
                RundeckJob job = new JobParser().parseXmlNode(skippedJobNode);
                result.addSkippedJob(job);
            }
        }
        if ((failedJobsNodes = resultNode.selectNodes("failed/job")) != null) {
            for (Node failedJobNode : failedJobsNodes) {
                RundeckJob job = new JobParser().parseXmlNode(failedJobNode);
                result.addFailedJob(job, failedJobNode.valueOf("error"));
            }
        }
        return result;
    }
}

