/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra;

import org.scassandra.Scassandra;
import org.scassandra.ServerStubRunner;
import org.scassandra.http.client.ActivityClient;
import org.scassandra.http.client.PrimingClient;

class ScassandraRunner
implements Scassandra {
    private final ServerStubRunner serverStubRunner;
    private final PrimingClient primingClient;
    private final ActivityClient activityClient;
    private final int binaryPort;
    private final int adminPort;

    ScassandraRunner(int binaryPort, int adminPort) {
        this.binaryPort = binaryPort;
        this.adminPort = adminPort;
        this.serverStubRunner = new ServerStubRunner(binaryPort, adminPort);
        this.primingClient = PrimingClient.builder().withPort(adminPort).build();
        this.activityClient = ActivityClient.builder().withPort(adminPort).build();
    }

    @Override
    public PrimingClient primingClient() {
        return this.primingClient;
    }

    @Override
    public ActivityClient activityClient() {
        return this.activityClient;
    }

    @Override
    public void start() {
        this.serverStubRunner.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.serverStubRunner.shutdown();
    }

    @Override
    public int getAdminPort() {
        return this.adminPort;
    }

    @Override
    public int getBinaryPort() {
        return this.binaryPort;
    }
}

