/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.scassandra.http.client.ColumnTypes;

public final class PrimingRequest {
    private final When when;
    private final Then then;

    public static PrimingRequestBuilder queryBuilder() {
        return new PrimingRequestBuilder(PrimingRequestBuilder.PrimeType.QUERY);
    }

    public static PrimingRequestBuilder preparedStatementBuilder() {
        return new PrimingRequestBuilder(PrimingRequestBuilder.PrimeType.PREPARED);
    }

    private PrimingRequest(String query, List<Consistency> consistency, List<Map<String, ? extends Object>> rows, Result result, Map<String, ColumnTypes> columnTypes, ColumnTypes[] variableTypes) {
        this.when = new When(query, consistency);
        this.then = new Then(rows, result, columnTypes, variableTypes);
    }

    public When getWhen() {
        return this.when;
    }

    public Then getThen() {
        return this.then;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimingRequest that = (PrimingRequest)o;
        if (this.then != null ? !this.then.equals(that.then) : that.then != null) {
            return false;
        }
        return !(this.when != null ? !this.when.equals(that.when) : that.when != null);
    }

    public int hashCode() {
        int result = this.when != null ? this.when.hashCode() : 0;
        result = 31 * result + (this.then != null ? this.then.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PrimingRequest{when='" + this.when + '\'' + ", then=" + this.then + '}';
    }

    public static enum Result {
        success,
        read_request_timeout,
        unavailable,
        write_request_timeout;

    }

    public static enum Consistency {
        ANY,
        ONE,
        TWO,
        THREE,
        QUORUM,
        ALL,
        LOCAL_QUORUM,
        EACH_QUORUM,
        SERIAL,
        LOCAL_SERIAL,
        LOCAL_ONE;

    }

    public static class When {
        private String query;
        private List<Consistency> consistency;

        private When(String query, List<Consistency> consistency) {
            this.query = query;
            this.consistency = consistency;
        }

        public String toString() {
            return "When{query='" + this.query + '\'' + ", consistency=" + this.consistency + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            When when = (When)o;
            if (this.consistency != null ? !this.consistency.equals(when.consistency) : when.consistency != null) {
                return false;
            }
            return !(this.query != null ? !this.query.equals(when.query) : when.query != null);
        }

        public int hashCode() {
            int result = this.query != null ? this.query.hashCode() : 0;
            result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
            return result;
        }

        public String getQuery() {
            return this.query;
        }

        public List<Consistency> getConsistency() {
            return Collections.unmodifiableList(this.consistency);
        }
    }

    public static class Then {
        private final ColumnTypes[] variable_types;
        private List<Map<String, ? extends Object>> rows;
        private Result result;
        private Map<String, ColumnTypes> column_types;

        private Then(List<Map<String, ? extends Object>> rows, Result result, Map<String, ColumnTypes> column_types, ColumnTypes[] variable_types) {
            this.rows = rows;
            this.result = result;
            this.column_types = column_types;
            this.variable_types = variable_types;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Then then = (Then)o;
            if (this.column_types != null ? !this.column_types.equals(then.column_types) : then.column_types != null) {
                return false;
            }
            if (this.result != then.result) {
                return false;
            }
            if (this.rows != null ? !this.rows.equals(then.rows) : then.rows != null) {
                return false;
            }
            return Arrays.equals((Object[])this.variable_types, (Object[])then.variable_types);
        }

        public int hashCode() {
            int result1 = this.variable_types != null ? Arrays.hashCode((Object[])this.variable_types) : 0;
            result1 = 31 * result1 + (this.rows != null ? this.rows.hashCode() : 0);
            result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
            result1 = 31 * result1 + (this.column_types != null ? this.column_types.hashCode() : 0);
            return result1;
        }

        public String toString() {
            return "Then{variable_types=" + Arrays.toString((Object[])this.variable_types) + ", rows=" + this.rows + ", result=" + (Object)((Object)this.result) + ", column_types=" + this.column_types + '}';
        }

        public ColumnTypes[] getVariableTypes() {
            return this.variable_types;
        }

        public List<Map<String, ? extends Object>> getRows() {
            return Collections.unmodifiableList(this.rows);
        }

        public Result getResult() {
            return this.result;
        }

        public Map<String, ColumnTypes> getColumnTypes() {
            return Collections.unmodifiableMap(this.column_types);
        }
    }

    public static class PrimingRequestBuilder {
        private PrimeType type;
        private Consistency[] consistency;
        private ColumnTypes[] variableTypes;
        private Map<String, ColumnTypes> columnTypes;
        private String query;
        private List<Map<String, ? extends Object>> rows;
        private Result result = Result.success;

        private PrimingRequestBuilder(PrimeType type) {
            this.type = type;
        }

        public PrimingRequestBuilder withQuery(String query) {
            this.query = query;
            return this;
        }

        public PrimingRequestBuilder withRows(List<Map<String, ? extends Object>> rows) {
            this.rows = rows;
            return this;
        }

        @SafeVarargs
        public final PrimingRequestBuilder withRows(Map<String, ? extends Object> ... rows) {
            this.rows = Arrays.asList(rows);
            return this;
        }

        public PrimingRequestBuilder withResult(Result result) {
            this.result = result;
            return this;
        }

        public PrimingRequest build() {
            if (PrimeType.QUERY.equals((Object)this.type) && this.variableTypes != null) {
                throw new IllegalStateException("Variable types only applicable for a prepared statement prime. Not a query prime.");
            }
            if (this.query == null) {
                throw new IllegalStateException("Must set query for PrimingRequest.");
            }
            List<Consistency> consistencies = this.consistency == null ? null : Arrays.asList(this.consistency);
            List<Map<String, Object>> rowsDefaultedToEmptyForSuccess = this.rows;
            if (this.result == Result.success && this.rows == null) {
                rowsDefaultedToEmptyForSuccess = Collections.emptyList();
            }
            return new PrimingRequest(this.query, consistencies, rowsDefaultedToEmptyForSuccess, this.result, this.columnTypes, this.variableTypes);
        }

        public PrimingRequestBuilder withConsistency(Consistency ... consistencies) {
            this.consistency = consistencies;
            return this;
        }

        public PrimingRequestBuilder withColumnTypes(Map<String, ColumnTypes> types) {
            this.columnTypes = types;
            return this;
        }

        public PrimingRequestBuilder withVariableTypes(ColumnTypes ... variableTypes) {
            this.variableTypes = variableTypes;
            return this;
        }

        private static enum PrimeType {
            QUERY,
            PREPARED;

        }
    }
}

