/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

public final class Query {
    private final String query;
    private final String consistency;

    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    private Query(String query, String consistency) {
        this.query = query;
        this.consistency = consistency;
    }

    public String getQuery() {
        return this.query;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public String toString() {
        return "Query{query='" + this.query + '\'' + ", consistency='" + this.consistency + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        if (this.consistency != null ? !this.consistency.equals(query1.consistency) : query1.consistency != null) {
            return false;
        }
        return !(this.query != null ? !this.query.equals(query1.query) : query1.query != null);
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
        return result;
    }

    public static class QueryBuilder {
        private String query;
        private String consistency = "ONE";

        private QueryBuilder() {
        }

        public QueryBuilder withQuery(String query) {
            this.query = query;
            return this;
        }

        public QueryBuilder withConsistency(String consistency) {
            this.consistency = consistency;
            return this;
        }

        public Query build() {
            if (this.query == null) {
                throw new IllegalStateException("Must set query");
            }
            return new Query(this.query, this.consistency);
        }
    }
}

