/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.scassandra.http.client.ColumnTypes;

public final class PrimingRequest {
    transient PrimingRequestBuilder.PrimeType primeType;
    private final When when;
    private final Then then;

    public static PrimingRequestBuilder queryBuilder() {
        return new PrimingRequestBuilder(PrimingRequestBuilder.PrimeType.QUERY);
    }

    public static PrimingRequestBuilder preparedStatementBuilder() {
        return new PrimingRequestBuilder(PrimingRequestBuilder.PrimeType.PREPARED);
    }

    private PrimingRequest(PrimingRequestBuilder.PrimeType primeType, String query, String queryPattern, List<Consistency> consistency, List<Map<String, ? extends Object>> rows, Result result, Map<String, ColumnTypes> columnTypes, ColumnTypes[] variableTypes) {
        this.primeType = primeType;
        this.when = new When(query, queryPattern, consistency);
        this.then = new Then(rows, result, columnTypes, variableTypes);
    }

    public When getWhen() {
        return this.when;
    }

    public Then getThen() {
        return this.then;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimingRequest that = (PrimingRequest)o;
        if (this.then != null ? !this.then.equals(that.then) : that.then != null) {
            return false;
        }
        return !(this.when != null ? !this.when.equals(that.when) : that.when != null);
    }

    public int hashCode() {
        int result = this.when != null ? this.when.hashCode() : 0;
        result = 31 * result + (this.then != null ? this.then.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PrimingRequest{when='" + this.when + '\'' + ", then=" + this.then + '}';
    }

    public static enum Result {
        success,
        read_request_timeout,
        unavailable,
        write_request_timeout;

    }

    public static enum Consistency {
        ANY,
        ONE,
        TWO,
        THREE,
        QUORUM,
        ALL,
        LOCAL_QUORUM,
        EACH_QUORUM,
        SERIAL,
        LOCAL_SERIAL,
        LOCAL_ONE;

    }

    public static final class When {
        private final String query;
        private final String queryPattern;
        private final List<Consistency> consistency;

        private When(String query, String queryPattern, List<Consistency> consistency) {
            this.query = query;
            this.consistency = consistency;
            this.queryPattern = queryPattern;
        }

        public String toString() {
            return "When{query='" + this.query + '\'' + ", queryPattern='" + this.queryPattern + '\'' + ", consistency=" + this.consistency + '}';
        }

        public int hashCode() {
            return Objects.hash(this.query, this.queryPattern, this.consistency);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            When other = (When)obj;
            return Objects.equals(this.query, other.query) && Objects.equals(this.queryPattern, other.queryPattern) && Objects.equals(this.consistency, other.consistency);
        }

        public String getQuery() {
            return this.query;
        }

        public List<Consistency> getConsistency() {
            return Collections.unmodifiableList(this.consistency);
        }
    }

    public static final class Then {
        private final ColumnTypes[] variable_types;
        private final List<Map<String, ? extends Object>> rows;
        private final Result result;
        private final Map<String, ColumnTypes> column_types;

        private Then(List<Map<String, ? extends Object>> rows, Result result, Map<String, ColumnTypes> column_types, ColumnTypes[] variable_types) {
            this.rows = rows;
            this.result = result;
            this.column_types = column_types;
            this.variable_types = variable_types;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.rows, this.result, this.column_types}) + Arrays.hashCode((Object[])this.variable_types);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Then other = (Then)obj;
            return Arrays.equals((Object[])this.variable_types, (Object[])other.variable_types) && Objects.equals(this.rows, other.rows) && Objects.equals((Object)this.result, (Object)other.result) && Objects.equals(this.column_types, other.column_types);
        }

        public String toString() {
            return "Then{variable_types=" + Arrays.toString((Object[])this.variable_types) + ", rows=" + this.rows + ", result=" + (Object)((Object)this.result) + ", column_types=" + this.column_types + '}';
        }

        public ColumnTypes[] getVariableTypes() {
            return this.variable_types;
        }

        public List<Map<String, ? extends Object>> getRows() {
            return Collections.unmodifiableList(this.rows);
        }

        public Result getResult() {
            return this.result;
        }

        public Map<String, ColumnTypes> getColumnTypes() {
            return Collections.unmodifiableMap(this.column_types);
        }
    }

    public static class PrimingRequestBuilder {
        PrimeType type;
        private Consistency[] consistency;
        private ColumnTypes[] variableTypes;
        private Map<String, ColumnTypes> columnTypes;
        private String query;
        private String queryPattern;
        private List<Map<String, ? extends Object>> rows;
        private Result result = Result.success;

        private PrimingRequestBuilder(PrimeType type) {
            this.type = type;
        }

        public PrimingRequestBuilder withQuery(String query) {
            this.query = query;
            return this;
        }

        public PrimingRequestBuilder withQueryPattern(String queryPattern) {
            this.queryPattern = queryPattern;
            return this;
        }

        public PrimingRequestBuilder withRows(List<Map<String, ? extends Object>> rows) {
            this.rows = rows;
            return this;
        }

        @SafeVarargs
        public final PrimingRequestBuilder withRows(Map<String, ? extends Object> ... rows) {
            this.rows = Arrays.asList(rows);
            return this;
        }

        public PrimingRequestBuilder withResult(Result result) {
            this.result = result;
            return this;
        }

        public PrimingRequest build() {
            if (PrimeType.QUERY.equals((Object)this.type) && this.variableTypes != null) {
                throw new IllegalStateException("Variable types only applicable for a prepared statement prime. Not a query prime");
            }
            if (this.query != null && this.queryPattern != null) {
                throw new IllegalStateException("Can't specify query and queryPattern");
            }
            if (this.query == null && this.queryPattern == null) {
                throw new IllegalStateException("Must set either query or queryPattern for PrimingRequest");
            }
            List<Consistency> consistencies = this.consistency == null ? null : Arrays.asList(this.consistency);
            List<Map<String, Object>> rowsDefaultedToEmptyForSuccess = this.rows;
            if (this.result == Result.success && this.rows == null) {
                rowsDefaultedToEmptyForSuccess = Collections.emptyList();
            }
            return new PrimingRequest(this.type, this.query, this.queryPattern, consistencies, rowsDefaultedToEmptyForSuccess, this.result, this.columnTypes, this.variableTypes);
        }

        public PrimingRequestBuilder withConsistency(Consistency ... consistencies) {
            this.consistency = consistencies;
            return this;
        }

        public PrimingRequestBuilder withColumnTypes(Map<String, ColumnTypes> types) {
            this.columnTypes = types;
            return this;
        }

        public PrimingRequestBuilder withVariableTypes(ColumnTypes ... variableTypes) {
            this.variableTypes = variableTypes;
            return this;
        }

        static enum PrimeType {
            QUERY,
            PREPARED;

        }
    }
}

