/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class PreparedStatementExecution {
    private final String preparedStatementText;
    private final String consistency;
    private final List<Object> variables;

    private PreparedStatementExecution(String preparedStatementText, String consistency, List<Object> variables) {
        this.preparedStatementText = preparedStatementText;
        this.consistency = consistency;
        this.variables = variables;
    }

    public String getPreparedStatementText() {
        return this.preparedStatementText;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public List<Object> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public String toString() {
        return "PreparedStatementExecution{preparedStatementText='" + this.preparedStatementText + '\'' + ", consistency='" + this.consistency + '\'' + ", variables=" + this.variables + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreparedStatementExecution that = (PreparedStatementExecution)o;
        if (this.consistency != null ? !this.consistency.equals(that.consistency) : that.consistency != null) {
            return false;
        }
        if (this.preparedStatementText != null ? !this.preparedStatementText.equals(that.preparedStatementText) : that.preparedStatementText != null) {
            return false;
        }
        return !(this.variables != null ? !this.variables.equals(that.variables) : that.variables != null);
    }

    public int hashCode() {
        int result = this.preparedStatementText != null ? this.preparedStatementText.hashCode() : 0;
        result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
        result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
        return result;
    }

    public static PreparedStatementExecutionBuilder builder() {
        return new PreparedStatementExecutionBuilder();
    }

    public static class PreparedStatementExecutionBuilder {
        private String preparedStatementText;
        private String consistency = "ONE";
        private List<Object> variables = Collections.emptyList();

        private PreparedStatementExecutionBuilder() {
        }

        public PreparedStatementExecutionBuilder withConsistency(String consistency) {
            this.consistency = consistency;
            return this;
        }

        public PreparedStatementExecutionBuilder withPreparedStatementText(String preparedStatementText) {
            this.preparedStatementText = preparedStatementText;
            return this;
        }

        public PreparedStatementExecutionBuilder withVariables(Object ... variables) {
            this.variables = Arrays.asList(variables);
            return this;
        }

        public PreparedStatementExecutionBuilder withVariables(List<Object> variables) {
            this.variables = variables;
            return this;
        }

        public PreparedStatementExecution build() {
            if (this.preparedStatementText == null) {
                throw new IllegalStateException("Must set PreparedStatementExecutionBuilder");
            }
            return new PreparedStatementExecution(this.preparedStatementText, this.consistency, this.variables);
        }
    }
}

