/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.matchers;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.scassandra.http.client.PreparedStatementExecution;

public class PreparedStatementMatcher
extends TypeSafeMatcher<List<PreparedStatementExecution>> {
    private PreparedStatementExecution expectedPreparedStatementExecution;

    public PreparedStatementMatcher(PreparedStatementExecution expectedPreparedStatementExecution) {
        if (expectedPreparedStatementExecution == null) {
            throw new IllegalArgumentException("null expectedPreparedStatementExecution");
        }
        this.expectedPreparedStatementExecution = expectedPreparedStatementExecution;
    }

    public void describeMismatchSafely(List<PreparedStatementExecution> preparedStatementExecutions, Description description) {
        description.appendText("the following prepared statements were executed: ");
        for (PreparedStatementExecution preparedStatement : preparedStatementExecutions) {
            description.appendText("\n" + preparedStatement);
        }
    }

    public void describeTo(Description description) {
        description.appendText("Expected prepared statement " + this.expectedPreparedStatementExecution + " to be executed");
    }

    protected boolean matchesSafely(List<PreparedStatementExecution> queries) {
        for (PreparedStatementExecution query : queries) {
            if (!this.doesPreparedStatementMatch(query)) continue;
            return true;
        }
        return false;
    }

    private boolean doesPreparedStatementMatch(PreparedStatementExecution actualPreparedStatementExecution) {
        if (!actualPreparedStatementExecution.getConsistency().equals(this.expectedPreparedStatementExecution.getConsistency())) {
            return false;
        }
        if (!actualPreparedStatementExecution.getPreparedStatementText().equals(this.expectedPreparedStatementExecution.getPreparedStatementText())) {
            return false;
        }
        List<Object> expectedVariables = this.expectedPreparedStatementExecution.getVariables();
        List<Object> actualVariables = actualPreparedStatementExecution.getVariables();
        if (expectedVariables.size() != actualVariables.size()) {
            return false;
        }
        for (int index = 0; index < expectedVariables.size(); ++index) {
            Double castToDouble;
            Object expectedVariable = expectedVariables.get(index);
            Object actualVariable = actualVariables.get(index);
            if (actualVariable instanceof Double && expectedVariable != null) {
                try {
                    castToDouble = new Double(expectedVariable.toString());
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (castToDouble.equals(actualVariable)) continue;
                return false;
            }
            if (expectedVariable instanceof UUID && !(actualVariable instanceof UUID)) {
                if (expectedVariable.toString().equals(actualVariable)) continue;
                return false;
            }
            if (expectedVariable instanceof Double) {
                try {
                    castToDouble = new Double(actualVariable.toString());
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (castToDouble.equals(expectedVariable)) continue;
                return false;
            }
            if (expectedVariable instanceof Float) {
                Float castToFloat;
                try {
                    castToFloat = new Float(actualVariable.toString());
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (castToFloat.equals(expectedVariable)) continue;
                return false;
            }
            if (expectedVariable instanceof InetAddress) {
                if (actualVariable.equals(((InetAddress)expectedVariable).getHostAddress())) continue;
                return false;
            }
            if (expectedVariable instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)expectedVariable;
                byte[] b = new byte[bb.remaining()];
                bb.get(b);
                String encodedExpected = Hex.encodeHexString((byte[])b);
                if (encodedExpected.equals(actualVariable.toString().replaceFirst("0x", ""))) continue;
                return false;
            }
            if (Objects.equals(expectedVariable, actualVariable)) continue;
            return false;
        }
        return true;
    }
}

