/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.scassandra.Scassandra;
import org.scassandra.http.client.ActivityClient;
import org.scassandra.http.client.PrimingClient;
import org.scassandra.server.ServerStubRunner;

class ScassandraRunner
implements Scassandra {
    private final ServerStubRunner serverStubRunner;
    private final PrimingClient primingClient;
    private final ActivityClient activityClient;
    private final int binaryPort;
    private final int adminPort;
    private final String versionurl;
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    private final Gson gson = new Gson();

    ScassandraRunner(String binaryListenAddress, int binaryPort, String adminListenAddress, int adminPort) {
        this.binaryPort = binaryPort;
        this.adminPort = adminPort;
        this.serverStubRunner = new ServerStubRunner(binaryListenAddress, binaryPort, adminListenAddress, adminPort);
        this.primingClient = PrimingClient.builder().withPort(adminPort).build();
        this.activityClient = ActivityClient.builder().withPort(adminPort).build();
        this.versionurl = "http://" + binaryListenAddress + ":" + adminPort + "/version";
    }

    @Override
    public PrimingClient primingClient() {
        return this.primingClient;
    }

    @Override
    public ActivityClient activityClient() {
        return this.activityClient;
    }

    @Override
    public void start() {
        this.serverStubRunner.start();
        this.serverStubRunner.awaitStartup();
    }

    @Override
    public void stop() {
        this.serverStubRunner.shutdown();
    }

    @Override
    public int getAdminPort() {
        return this.adminPort;
    }

    @Override
    public int getBinaryPort() {
        return this.binaryPort;
    }

    @Override
    public String serverVersion() {
        HttpGet get = new HttpGet(this.versionurl);
        try {
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map version = (Map)this.gson.fromJson(EntityUtils.toString((HttpEntity)this.httpClient.execute((HttpUriRequest)get).getEntity()), type);
            return (String)version.get("version");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get version", e);
        }
    }
}

