/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.ActivityRequestFailed;
import org.scassandra.http.client.Connection;
import org.scassandra.http.client.PreparedStatementExecution;
import org.scassandra.http.client.Query;
import org.scassandra.http.client.types.GsonCqlTypeDeserialiser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityClient {
    public static final String REQUEST_FOR_QUERIES_FAILED = "Request for queries failed";
    public static final String REQUEST_FOR_CONNECTIONS_FAILED = "Request for connections failed";
    public static final String REQUEST_FAILED = "Request failed";
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityClient.class);
    private Gson gson = new GsonBuilder().registerTypeAdapter(CqlType.class, (Object)new GsonCqlTypeDeserialiser()).create();
    private CloseableHttpClient httpClient = HttpClients.createDefault();
    private final String connectionUrl;
    private final String queryUrl;
    private final String preparedStatementExecutionUrl;

    public static ActivityClientBuilder builder() {
        return new ActivityClientBuilder();
    }

    private ActivityClient(String host, int port) {
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(500);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(500);
        requestBuilder = requestBuilder.setSocketTimeout(500);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build());
        this.httpClient = builder.build();
        this.connectionUrl = "http://" + host + ":" + port + "/connection";
        this.queryUrl = "http://" + host + ":" + port + "/query";
        this.preparedStatementExecutionUrl = "http://" + host + ":" + port + "/prepared-statement-execution";
    }

    public List<Query> retrieveQueries() {
        HttpGet get = new HttpGet(this.queryUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            Object[] queries = (Query[])this.gson.fromJson(body, Query[].class);
            LOGGER.debug("Parsed queries {}", (Object)Arrays.toString(queries));
            return Arrays.asList(queries);
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FOR_QUERIES_FAILED, (Throwable)e);
            throw new ActivityRequestFailed(REQUEST_FOR_QUERIES_FAILED, e);
        }
    }

    public List<Connection> retrieveConnections() {
        HttpGet get = new HttpGet(this.connectionUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            Object[] queries = (Connection[])this.gson.fromJson(body, Connection[].class);
            LOGGER.debug("Parsed connections {}", (Object)Arrays.toString(queries));
            return Arrays.asList(queries);
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FOR_CONNECTIONS_FAILED, (Throwable)e);
            throw new ActivityRequestFailed(REQUEST_FOR_CONNECTIONS_FAILED, e);
        }
    }

    public void clearConnections() {
        this.httpDelete(this.connectionUrl, "Clearing of connections failed");
    }

    public void clearQueries() {
        this.httpDelete(this.queryUrl, "Clearing of queries failed");
    }

    public void clearPreparedStatementExecutions() {
        this.httpDelete(this.preparedStatementExecutionUrl, "Clearing of prepared statement executions failed");
    }

    public void clearAllRecordedActivity() {
        this.clearConnections();
        this.clearQueries();
        this.clearPreparedStatementExecutions();
    }

    public List<PreparedStatementExecution> retrievePreparedStatementExecutions() {
        HttpGet get = new HttpGet(this.preparedStatementExecutionUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String errorMessage = String.format("Non 200 status code when retrieving prepared statement executions %s", statusCode);
                LOGGER.info(errorMessage);
                throw new ActivityRequestFailed(errorMessage);
            }
            Object[] executions = (PreparedStatementExecution[])this.gson.fromJson(body, PreparedStatementExecution[].class);
            LOGGER.debug("Parsed prepared statement executions {}", (Object)Arrays.toString(executions));
            return Arrays.asList(executions);
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FAILED, (Throwable)e);
            throw new ActivityRequestFailed(REQUEST_FAILED, e);
        }
    }

    private void httpDelete(String url, String warningMessage) {
        HttpDelete delete = new HttpDelete(url);
        try {
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)delete);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException e) {
            LOGGER.warn(warningMessage, (Throwable)e);
            throw new ActivityRequestFailed(warningMessage, e);
        }
    }

    public static class ActivityClientBuilder {
        private String host = "localhost";
        private int port = 8043;

        private ActivityClientBuilder() {
        }

        public ActivityClientBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public ActivityClientBuilder withPort(int port) {
            this.port = port;
            return this;
        }

        public ActivityClient build() {
            return new ActivityClient(this.host, this.port);
        }
    }
}

