/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.PrimeFailedException;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.types.GsonCqlTypeDeserialiser;
import org.scassandra.http.client.types.GsonCqlTypeSerialiser;
import org.scassandra.http.client.types.GsonInetAddressSerialiser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimingClient {
    public static final String DELETING_OF_PRIMES_FAILED = "Deleting of primes failed";
    public static final String PRIMING_FAILED = "Priming failed";
    private static final Logger LOGGER = LoggerFactory.getLogger(PrimingClient.class);
    private Gson gson = new GsonBuilder().registerTypeAdapter(CqlType.class, (Object)new GsonCqlTypeSerialiser()).registerTypeAdapter(CqlType.class, (Object)new GsonCqlTypeDeserialiser()).registerTypeAdapter(InetAddress.class, (Object)new GsonInetAddressSerialiser()).enableComplexMapKeySerialization().create();
    private CloseableHttpClient httpClient = HttpClients.createDefault();
    private String primeQueryUrl;
    private String primePreparedUrl;

    public static PrimingClientBuilder builder() {
        return new PrimingClientBuilder();
    }

    private PrimingClient(String host, int port) {
        this.primeQueryUrl = "http://" + host + ":" + port + "/prime-query-single";
        this.primePreparedUrl = "http://" + host + ":" + port + "/prime-prepared-single";
    }

    public void prime(PrimingRequest prime) throws PrimeFailedException {
        if (prime.primeType == PrimingRequest.PrimingRequestBuilder.PrimeType.QUERY) {
            this.primeQuery(prime);
        } else {
            this.primePreparedStatement(prime);
        }
    }

    @Deprecated
    public void primeQuery(PrimingRequest primeRequest) throws PrimeFailedException {
        if (primeRequest.primeType != PrimingRequest.PrimingRequestBuilder.PrimeType.QUERY) {
            throw new IllegalArgumentException("Can't pass a prepared statement prime to primeQuery, use queryBuilder()");
        }
        this.prime(primeRequest, this.primeQueryUrl);
    }

    @Deprecated
    public void primePreparedStatement(PrimingRequest primeRequest) throws PrimeFailedException {
        if (primeRequest.primeType != PrimingRequest.PrimingRequestBuilder.PrimeType.PREPARED) {
            throw new IllegalArgumentException("Can't pass a query prime to primePreparedStatement, use preparedStatementBuilder()");
        }
        this.prime(primeRequest, this.primePreparedUrl);
    }

    public List<PrimingRequest> retrievePreparedPrimes() {
        return this.httpGetPrimingRequests(this.primePreparedUrl);
    }

    public List<PrimingRequest> retrieveQueryPrimes() {
        return this.httpGetPrimingRequests(this.primeQueryUrl);
    }

    public void clearAllPrimes() {
        this.clearQueryPrimes();
        this.clearPreparedPrimes();
    }

    public void clearQueryPrimes() {
        this.httpDelete(this.primeQueryUrl);
    }

    public void clearPreparedPrimes() {
        this.httpDelete(this.primePreparedUrl);
    }

    private List<PrimingRequest> httpGetPrimingRequests(String url) {
        HttpGet get = new HttpGet(url);
        try {
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)get);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String responseAsString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            if (statusCode != 200) {
                String errorMessage = String.format("Retrieving of primes failed with http status %s body %s", statusCode, responseAsString);
                LOGGER.info(errorMessage);
                throw new PrimeFailedException(errorMessage);
            }
            LOGGER.debug("Received response from scassandra {}", (Object)responseAsString);
            PrimingRequest[] primes = (PrimingRequest[])this.gson.fromJson(responseAsString, PrimingRequest[].class);
            return Arrays.asList(primes);
        }
        catch (IOException e) {
            LOGGER.info("Retrieving failed", (Throwable)e);
            throw new PrimeFailedException("Retrieving of primes failed.", e);
        }
    }

    private void httpDelete(String url) {
        HttpDelete delete = new HttpDelete(url);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)delete);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String errorMessage = String.format("Clearing of primes failed with http status %s", statusCode);
                LOGGER.info(errorMessage);
                throw new PrimeFailedException(errorMessage);
            }
        }
        catch (IOException e) {
            LOGGER.info(DELETING_OF_PRIMES_FAILED, (Throwable)e);
            throw new PrimeFailedException(DELETING_OF_PRIMES_FAILED, e);
        }
        finally {
            if (httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
    }

    private void prime(PrimingRequest primeRequest, String url) {
        HttpPost httpPost = new HttpPost(url);
        String jsonAsString = this.gson.toJson((Object)primeRequest);
        LOGGER.info("Sending {} to url {}", (Object)jsonAsString, (Object)url);
        httpPost.setEntity((HttpEntity)new StringEntity(jsonAsString, ContentType.APPLICATION_JSON));
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                String body = EntityUtils.toString((HttpEntity)response.getEntity());
                String errorMessage = String.format("Priming came back with non-200 response code: %s and body: %s", response.getStatusLine(), body);
                LOGGER.warn(errorMessage);
                throw new PrimeFailedException(errorMessage);
            }
        }
        catch (IOException e) {
            LOGGER.warn(PRIMING_FAILED, (Throwable)e);
            throw new PrimeFailedException(PRIMING_FAILED, e);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public static class PrimingClientBuilder {
        private String host = "localhost";
        private int port = 8043;

        private PrimingClientBuilder() {
        }

        public PrimingClientBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public PrimingClientBuilder withPort(int port) {
            this.port = port;
            return this;
        }

        public PrimingClient build() {
            return new PrimingClient(this.host, this.port);
        }
    }
}

