/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.matchers;

import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.PreparedStatementExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementMatcher
extends TypeSafeMatcher<List<PreparedStatementExecution>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreparedStatementMatcher.class);
    private PreparedStatementExecution expectedPreparedStatementExecution;

    public PreparedStatementMatcher(PreparedStatementExecution expectedPreparedStatementExecution) {
        if (expectedPreparedStatementExecution == null) {
            throw new IllegalArgumentException("null expectedPreparedStatementExecution");
        }
        this.expectedPreparedStatementExecution = expectedPreparedStatementExecution;
    }

    public void describeMismatchSafely(List<PreparedStatementExecution> preparedStatementExecutions, Description description) {
        description.appendText("the following prepared statements were executed: ");
        for (PreparedStatementExecution preparedStatement : preparedStatementExecutions) {
            description.appendText("\n" + preparedStatement);
        }
    }

    public void describeTo(Description description) {
        description.appendText("Expected prepared statement " + this.expectedPreparedStatementExecution + " to be executed");
    }

    protected boolean matchesSafely(List<PreparedStatementExecution> queries) {
        for (int i = 0; i < queries.size(); ++i) {
            PreparedStatementExecution actualPreparedStatementExecution = queries.get(i);
            try {
                if (!this.doesPreparedStatementMatch(actualPreparedStatementExecution)) continue;
                return true;
            }
            catch (IllegalArgumentException e) {
                if (i == queries.size() - 1) {
                    throw e;
                }
                LOGGER.info("Found prepared statement execution that didn't match: {}, reason: {}", (Object)actualPreparedStatementExecution, (Object)e.getMessage());
            }
        }
        return false;
    }

    private boolean doesPreparedStatementMatch(PreparedStatementExecution actualPreparedStatementExecution) {
        List<CqlType> variableTypes = actualPreparedStatementExecution.getVariableTypes();
        List<Object> actualVariables = actualPreparedStatementExecution.getVariables();
        if (variableTypes.size() != actualVariables.size()) {
            throw new IllegalArgumentException(String.format("Server has returned a different number of variables to variable types: variables %s variableTypes %s", actualVariables, variableTypes));
        }
        if (!actualPreparedStatementExecution.getConsistency().equals(this.expectedPreparedStatementExecution.getConsistency())) {
            return false;
        }
        if (!actualPreparedStatementExecution.getPreparedStatementText().equals(this.expectedPreparedStatementExecution.getPreparedStatementText())) {
            return false;
        }
        List<Object> expectedVariables = this.expectedPreparedStatementExecution.getVariables();
        if (expectedVariables.size() != actualVariables.size()) {
            return false;
        }
        for (int index = 0; index < expectedVariables.size(); ++index) {
            Object expectedVariable = expectedVariables.get(index);
            Object actualVariable = actualVariables.get(index);
            CqlType columnType = variableTypes.get(index);
            if (columnType.equals(expectedVariable, actualVariable)) continue;
            return false;
        }
        return true;
    }
}

