/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.matchers;

import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.scassandra.http.client.Query;

class QueryMatcher
extends TypeSafeMatcher<List<Query>> {
    private Query query;

    public QueryMatcher(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("null query");
        }
        this.query = query;
    }

    protected boolean matchesSafely(List<Query> queries) {
        return queries.contains(this.query);
    }

    public void describeMismatchSafely(List<Query> actual, Description description) {
        description.appendText("the following queries were executed: ");
        for (Query query : actual) {
            description.appendText("\n" + query);
        }
    }

    public void describeTo(Description description) {
        description.appendText("Expected query " + this.query + " to be executed");
    }
}

