/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.Consistency;
import org.scassandra.http.client.Result;

public final class MultiPrimeRequest {
    private final When when;
    private final Then then;

    public static MultiPrimeRequestBuilder request() {
        return new MultiPrimeRequestBuilder();
    }

    public static Then.Builder then() {
        return new Then.Builder();
    }

    public static When.Builder when() {
        return new When.Builder();
    }

    public static Criteria.Builder match() {
        return new Criteria.Builder();
    }

    public static Action.Builder action() {
        return new Action.Builder();
    }

    public static Outcome outcome(Criteria.Builder match, Action.Builder action) {
        return new Outcome(match.build(), action.build());
    }

    public static ExactMatch.Builder exactMatch() {
        return new ExactMatch.Builder();
    }

    public static VariableMatch exactMatch(Object o) {
        return new ExactMatch.Builder().withMatcher(o).build();
    }

    public static VariableMatch anyMatch() {
        return new AnyMatch();
    }

    private MultiPrimeRequest(When when, Then then) {
        this.when = when;
        this.then = then;
    }

    public When getWhen() {
        return this.when;
    }

    public Then getThen() {
        return this.then;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiPrimeRequest that = (MultiPrimeRequest)o;
        if (this.when != null ? !this.when.equals(that.when) : that.when != null) {
            return false;
        }
        return this.then != null ? this.then.equals(that.then) : that.then == null;
    }

    public int hashCode() {
        int result = this.when != null ? this.when.hashCode() : 0;
        result = 31 * result + (this.then != null ? this.then.hashCode() : 0);
        return result;
    }

    public static class MultiPrimeRequestBuilder {
        private When when;
        private Then then;

        private MultiPrimeRequestBuilder() {
        }

        public static MultiPrimeRequestBuilder multiPrimeRequest() {
            return new MultiPrimeRequestBuilder();
        }

        public MultiPrimeRequestBuilder withWhen(When.Builder when) {
            this.when = when.build();
            return this;
        }

        public MultiPrimeRequestBuilder withThen(Then.Builder then) {
            this.then = then.build();
            return this;
        }

        public MultiPrimeRequest build() {
            return new MultiPrimeRequest(this.when, this.then);
        }
    }

    public static final class When {
        private final String query;
        private final List<Consistency> consistency;

        private When(String query, List<Consistency> consistency) {
            this.query = query;
            this.consistency = consistency;
        }

        public String getQuery() {
            return this.query;
        }

        public List<Consistency> getConsistency() {
            return Collections.unmodifiableList(this.consistency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            When when = (When)o;
            if (this.query != null ? !this.query.equals(when.query) : when.query != null) {
                return false;
            }
            return this.consistency != null ? this.consistency.equals(when.consistency) : when.consistency == null;
        }

        public int hashCode() {
            int result = this.query != null ? this.query.hashCode() : 0;
            result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
            return result;
        }

        public static class Builder {
            private String query;
            private List<Consistency> consistency;

            private Builder() {
            }

            public Builder withQuery(String query) {
                this.query = query;
                return this;
            }

            public Builder withConsistency(List<Consistency> consistency) {
                this.consistency = consistency;
                return this;
            }

            public Builder withConsistency(Consistency consistency, Consistency ... consistencies) {
                this.consistency = new ArrayList<Consistency>();
                this.consistency.add(consistency);
                this.consistency.addAll(Arrays.asList(consistencies));
                return this;
            }

            public When build() {
                return new When(this.query, this.consistency);
            }
        }
    }

    public static class Outcome {
        private Criteria criteria;
        private Action action;

        public Outcome(Criteria criteria, Action action) {
            this.criteria = criteria;
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Outcome outcome = (Outcome)o;
            if (this.criteria != null ? !this.criteria.equals(outcome.criteria) : outcome.criteria != null) {
                return false;
            }
            return !(this.action == null ? outcome.action != null : !this.action.equals(outcome.action));
        }

        public int hashCode() {
            int result = this.criteria != null ? this.criteria.hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            return result;
        }
    }

    public static final class Then {
        private final List<CqlType> variable_types;
        private final List<Outcome> outcomes;

        public Then(List<CqlType> variable_types, List<Outcome> outcomes) {
            this.variable_types = variable_types;
            this.outcomes = outcomes;
        }

        public List<CqlType> getVariableTypes() {
            return this.variable_types;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Then then = (Then)o;
            if (this.variable_types != null ? !this.variable_types.equals(then.variable_types) : then.variable_types != null) {
                return false;
            }
            return this.outcomes != null ? this.outcomes.equals(then.outcomes) : then.outcomes == null;
        }

        public int hashCode() {
            int result = this.variable_types != null ? this.variable_types.hashCode() : 0;
            result = 31 * result + (this.outcomes != null ? this.outcomes.hashCode() : 0);
            return result;
        }

        public static class Builder {
            private List<CqlType> variable_types;
            private List<Outcome> outcomes;

            private Builder() {
            }

            public Builder withVariableTypes(List<CqlType> variable_types) {
                this.variable_types = variable_types;
                return this;
            }

            public Builder withVariableTypes(CqlType ... variable_types) {
                this.variable_types = Arrays.asList(variable_types);
                return this;
            }

            public Builder withOutcomes(Outcome ... outcomes) {
                this.outcomes = Arrays.asList(outcomes);
                return this;
            }

            public Then build() {
                return new Then(this.variable_types, this.outcomes);
            }
        }
    }

    public static final class Criteria {
        private final List<VariableMatch> variable_matcher;

        public Criteria(List<VariableMatch> variable_matcher) {
            this.variable_matcher = variable_matcher;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Criteria criteria = (Criteria)o;
            return this.variable_matcher != null ? this.variable_matcher.equals(criteria.variable_matcher) : criteria.variable_matcher == null;
        }

        public int hashCode() {
            return this.variable_matcher != null ? this.variable_matcher.hashCode() : 0;
        }

        public static class Builder {
            private List<VariableMatch> variable_matcher;

            private Builder() {
            }

            public Builder withVariableMatchers(VariableMatch ... variable_matcher) {
                this.variable_matcher = Arrays.asList(variable_matcher);
                return this;
            }

            public Criteria build() {
                return new Criteria(this.variable_matcher);
            }
        }
    }

    public static final class ExactMatch
    extends VariableMatch {
        private final Object matcher;

        public ExactMatch(Object matcher) {
            this.matcher = matcher;
        }

        @Override
        public MatchType type() {
            return MatchType.exact;
        }

        public Object matcher() {
            return this.matcher;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExactMatch that = (ExactMatch)o;
            return this.matcher != null ? this.matcher.equals(that.matcher) : that.matcher == null;
        }

        @Override
        public int hashCode() {
            return this.matcher != null ? this.matcher.hashCode() : 0;
        }

        public static class Builder {
            private Object matcher;

            private Builder() {
            }

            public Builder withMatcher(Object matcher) {
                this.matcher = matcher;
                return this;
            }

            public ExactMatch build() {
                return new ExactMatch(this.matcher);
            }
        }
    }

    public static class AnyMatch
    extends VariableMatch {
        @Override
        public MatchType type() {
            return MatchType.any;
        }
    }

    public static abstract class VariableMatch {
        private MatchType type = this.type();

        protected abstract MatchType type();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariableMatch that = (VariableMatch)o;
            return this.type == that.type;
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }
    }

    public static enum MatchType {
        exact,
        any;

    }

    public static final class Action {
        private final List<Map<String, ? extends Object>> rows;
        private final Result result;
        private final Map<String, CqlType> column_types;
        private final Long fixedDelay;
        private final Map<String, Object> config;

        private Action(List<Map<String, ? extends Object>> rows, Result result, Map<String, CqlType> column_types, Long fixedDelay, Map<String, Object> config) {
            this.rows = rows;
            this.result = result;
            this.column_types = column_types;
            this.fixedDelay = fixedDelay;
            this.config = config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Action aAction = (Action)o;
            if (this.rows != null ? !this.rows.equals(aAction.rows) : aAction.rows != null) {
                return false;
            }
            if (this.result != aAction.result) {
                return false;
            }
            if (this.column_types != null ? !this.column_types.equals(aAction.column_types) : aAction.column_types != null) {
                return false;
            }
            if (this.fixedDelay != null ? !this.fixedDelay.equals(aAction.fixedDelay) : aAction.fixedDelay != null) {
                return false;
            }
            return this.config != null ? this.config.equals(aAction.config) : aAction.config == null;
        }

        public int hashCode() {
            int result1 = this.rows != null ? this.rows.hashCode() : 0;
            result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
            result1 = 31 * result1 + (this.column_types != null ? this.column_types.hashCode() : 0);
            result1 = 31 * result1 + (this.fixedDelay != null ? this.fixedDelay.hashCode() : 0);
            result1 = 31 * result1 + (this.config != null ? this.config.hashCode() : 0);
            return result1;
        }

        public static class Builder {
            private List<Map<String, ? extends Object>> rows;
            private Result result;
            private Map<String, CqlType> column_types;
            private Long fixedDelay;
            private Map<String, Object> config;

            private Builder() {
            }

            public Builder withRows(List<Map<String, ? extends Object>> rows) {
                this.rows = rows;
                return this;
            }

            @SafeVarargs
            public final Builder withRows(Map<String, ? extends Object> ... rows) {
                this.rows = Arrays.asList(rows);
                return this;
            }

            public Builder withResult(Result result) {
                this.result = result;
                return this;
            }

            public Builder withColumnTypes(Map<String, CqlType> column_types) {
                this.column_types = column_types;
                return this;
            }

            public Builder withFixedDelay(Long fixedDelay) {
                this.fixedDelay = fixedDelay;
                return this;
            }

            public Builder withConfig(Map<String, Object> config) {
                this.config = config;
                return this;
            }

            public Action build() {
                return new Action(this.rows, this.result, this.column_types, this.fixedDelay, this.config);
            }
        }
    }
}

