/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

public class DragAndDrop
extends SeleneseCommand<Void> {
    private final ElementFinder finder;

    public DragAndDrop(ElementFinder finder) {
        this.finder = finder;
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String locator, String movementsString) {
        String[] parts = movementsString.split("\\s*,\\s*", 2);
        int xDelta = Integer.parseInt(parts[0].trim());
        int yDelta = Integer.parseInt(parts[1].trim());
        WebElement element = this.finder.findElement(driver, locator);
        new Actions(driver).dragAndDropBy(element, xDelta, yDelta).perform();
        return null;
    }
}

