/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.thoughtworks.selenium.SeleniumException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.JavascriptLibrary;

public class ElementFinder {
    private static final Logger log = Logger.getLogger(ElementFinder.class.getName());
    private final String findElement;
    private final String sizzle;
    private final Map<String, String> additionalLocators = Maps.newHashMap();

    @VisibleForTesting
    protected ElementFinder() {
        this.findElement = null;
        this.sizzle = null;
    }

    public ElementFinder(JavascriptLibrary library) {
        String rawScript = library.getSeleniumScript("findElement.js");
        this.findElement = "return (" + rawScript + ")(arguments[0]);";
        String linkTextLocator = "return (" + library.getSeleniumScript("linkLocator.js") + ").call(null, arguments[0], document)";
        this.add("link", linkTextLocator);
        try {
            URL url = Resources.getResource((String)(this.getClass().getPackage().getName().replace(".", "/") + "/sizzle.js"));
            this.sizzle = Resources.toString((URL)url, (Charset)Charsets.UTF_8) + "var results = []; " + "try { Sizzle(arguments[0], document, results);} " + "catch (ignored) {} " + "return results.length ? results[0] : null;";
            this.add("sizzle", this.sizzle);
        }
        catch (IOException e) {
            throw new SeleniumException("Cannot read sizzle");
        }
    }

    public WebElement findElement(WebDriver driver, String locator) {
        WebElement toReturn = null;
        String strategy = this.searchAdditionalStrategies(locator);
        if (strategy != null) {
            String actualLocator = locator.substring(locator.indexOf(61) + 1);
            try {
                toReturn = (WebElement)((JavascriptExecutor)driver).executeScript(strategy, new Object[]{actualLocator});
                if (toReturn == null) {
                    throw new SeleniumException("Element " + locator + " not found");
                }
                return toReturn;
            }
            catch (WebDriverException e) {
                throw new SeleniumException("Element " + locator + " not found");
            }
        }
        try {
            toReturn = this.findElementDirectlyIfNecessary(driver, locator);
            if (toReturn != null) {
                return toReturn;
            }
            return (WebElement)((JavascriptExecutor)driver).executeScript(this.findElement, new Object[]{locator});
        }
        catch (WebDriverException e) {
            throw new SeleniumException("Element " + locator + " not found", (Exception)((Object)e));
        }
    }

    public void add(String strategyName, String implementation) {
        this.additionalLocators.put(strategyName, implementation);
    }

    private String searchAdditionalStrategies(String locator) {
        int index = locator.indexOf(61);
        if (index == -1) {
            return null;
        }
        String key = locator.substring(0, index);
        return this.additionalLocators.get(key);
    }

    private WebElement findElementDirectlyIfNecessary(WebDriver driver, String locator) {
        if (locator.startsWith("xpath=")) {
            return this.xpathWizardry(driver, locator.substring("xpath=".length()));
        }
        if (locator.startsWith("//")) {
            return this.xpathWizardry(driver, locator);
        }
        if (locator.startsWith("css=")) {
            String selector = locator.substring("css=".length());
            try {
                return driver.findElement(By.cssSelector((String)selector));
            }
            catch (WebDriverException e) {
                return this.fallbackToSizzle(driver, selector);
            }
        }
        if (locator.startsWith("link=")) {
            // empty if block
        }
        return null;
    }

    private WebElement xpathWizardry(WebDriver driver, String xpath) {
        try {
            return driver.findElement(By.xpath((String)xpath));
        }
        catch (WebDriverException webDriverException) {
            if (xpath.endsWith("/")) {
                return driver.findElement(By.xpath((String)xpath.substring(0, xpath.length() - 1)));
            }
            throw new NoSuchElementException("Cannot find an element with the xpath: " + xpath);
        }
    }

    private WebElement fallbackToSizzle(WebDriver driver, String locator) {
        WebElement toReturn = (WebElement)((JavascriptExecutor)driver).executeScript(this.sizzle, new Object[]{locator});
        if (toReturn != null) {
            log.warning("You are using a Sizzle locator as a CSS Selector. Please use the Sizzle library directly via the JavascriptExecutor or a plain CSS selector. Your locator was: " + locator);
            return toReturn;
        }
        throw new NoSuchElementException("Cannot locate element even after falling back to Sizzle: " + locator);
    }
}

