/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core;

import java.util.Locale;
import org.sellcom.core.Contract;

public class Strings {
    private Strings() {
    }

    public static String emptyToNull(String string) {
        return Strings.isNullOrEmpty(string) ? null : string;
    }

    public static boolean endsWith(String string, String suffix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(suffix != null, "Suffix must not be null", new Object[0]);
        return string.regionMatches(ignoreCase, string.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static String ensurePrefix(String string, String prefix) {
        return Strings.ensurePrefix(string, prefix, false);
    }

    public static String ensurePrefix(String string, String prefix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(prefix != null, "Prefix must not be null", new Object[0]);
        if (!Strings.startsWith(string, prefix, ignoreCase)) {
            return prefix + string;
        }
        return string;
    }

    public static String ensureSuffix(String string, String suffix) {
        return Strings.ensureSuffix(string, suffix, false);
    }

    public static String ensureSuffix(String string, String suffix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(suffix != null, "Suffix must not be null", new Object[0]);
        if (!Strings.endsWith(string, suffix, ignoreCase)) {
            return string + suffix;
        }
        return string;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String normalizeWhitespace(String string) {
        Contract.checkArgument(string != null, "string must not be null", new Object[0]);
        String result = string.trim();
        result = result.replaceAll("\\p{Space}+", " ");
        return result;
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static String removePrefix(String string, String prefix) {
        return Strings.removePrefix(string, prefix, false);
    }

    public static String removePrefix(String string, String prefix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(prefix != null, "Prefix must not be null", new Object[0]);
        int prefixPosition = 0;
        if (string.regionMatches(ignoreCase, prefixPosition, prefix, 0, prefix.length())) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String removeSuffix(String string, String suffix) {
        return Strings.removeSuffix(string, suffix, false);
    }

    public static String removeSuffix(String string, String suffix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(suffix != null, "Suffix must not be null", new Object[0]);
        int suffixPosition = string.length() - suffix.length();
        if (string.regionMatches(ignoreCase, suffixPosition, suffix, 0, suffix.length())) {
            return string.substring(0, suffixPosition);
        }
        return string;
    }

    public static String removeWhitespace(String string) {
        Contract.checkArgument(string != null, "string must not be null", new Object[0]);
        return string.replaceAll("(?U)\\p{Space}+", "");
    }

    public static boolean startsWith(String string, String prefix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(prefix != null, "Prefix must not be null", new Object[0]);
        return string.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static String toLowerCase(String string) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        return string.toLowerCase(Locale.ROOT);
    }

    public static String toUpperCase(String string) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        return string.toUpperCase(Locale.ROOT);
    }
}

