/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.util.ArrayUtils;
import org.sellcom.core.util.MoreArrays;

public class SparseDoubleArray
implements Cloneable {
    private static final int DEFAULT_CAPACITY = 10;
    private double[] elements;
    private int[] indices;
    private int size;

    public SparseDoubleArray() {
        this(10);
    }

    public SparseDoubleArray(int initialCapacity) {
        this.elements = new double[initialCapacity];
        this.indices = new int[initialCapacity];
        this.size = 0;
    }

    public void clear() {
        this.size = 0;
    }

    public SparseDoubleArray clone() {
        SparseDoubleArray clone = null;
        try {
            clone = (SparseDoubleArray)super.clone();
            clone.elements = (double[])this.elements.clone();
            clone.indices = (int[])this.indices.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public boolean containsElement(double element, double tolerance) {
        return MoreArrays.indexOf(this.elements, 0, this.size, element, tolerance) >= 0;
    }

    public boolean containsIndex(int index) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        return Arrays.binarySearch(this.indices, 0, this.size, index) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        Contract.checkArgument(minCapacity >= 0, "Minimum capacity must not be negative: {0}", minCapacity);
        if (minCapacity > this.elements.length) {
            int targetCapacity = Math.max(minCapacity, 2 * this.elements.length);
            this.elements = Arrays.copyOf(this.elements, targetCapacity);
            this.indices = Arrays.copyOf(this.indices, targetCapacity);
        }
    }

    public void forEach(BiConsumer<Integer, Double> action) {
        Contract.checkArgument(action != null, "Action must not be null", new Object[0]);
        for (int i = 0; i < this.size; ++i) {
            action.accept(this.indices[i], this.elements[i]);
        }
    }

    public double getOrDefault(int index, double defaultValue) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        int internalIndex = Arrays.binarySearch(this.indices, 0, this.size, index);
        if (internalIndex < 0) {
            return defaultValue;
        }
        return this.elements[internalIndex];
    }

    public int indexOf(double element, double tolerance) {
        int internalIndex = MoreArrays.indexOf(this.elements, 0, this.size, element, tolerance);
        return internalIndex == -1 ? -1 : this.indices[internalIndex];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(double element, double tolerance) {
        int internalIndex = MoreArrays.lastIndexOf(this.elements, 0, this.size, element, tolerance);
        return internalIndex == -1 ? -1 : this.indices[internalIndex];
    }

    public double remove(int index, double defaultValue) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        int internalIndex = Arrays.binarySearch(this.indices, 0, this.size, index);
        if (internalIndex < 0) {
            return defaultValue;
        }
        double element = this.elements[internalIndex];
        ArrayUtils.shiftLeft(this.elements, internalIndex + 1, this.size);
        ArrayUtils.shiftLeft(this.indices, internalIndex + 1, this.size);
        --this.size;
        return element;
    }

    public void set(int index, double value) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        int internalIndex = Arrays.binarySearch(this.indices, 0, this.size, index);
        if (internalIndex < 0) {
            this.ensureCapacity(this.size + 1);
            internalIndex = -internalIndex - 1;
            ArrayUtils.shiftRight(this.elements, internalIndex, this.size);
            this.elements[internalIndex] = value;
            ArrayUtils.shiftRight(this.indices, internalIndex, this.size);
            this.indices[internalIndex] = index;
            ++this.size;
        } else {
            int elementIndex = this.indices[internalIndex];
            this.elements[elementIndex] = value;
        }
    }

    public void setIfAbsent(int index, double value) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        int internalIndex = Arrays.binarySearch(this.indices, 0, this.size, index);
        if (internalIndex < 0) {
            this.ensureCapacity(this.size + 1);
            internalIndex = -internalIndex - 1;
            ArrayUtils.shiftRight(this.elements, internalIndex, this.size);
            this.elements[internalIndex] = value;
            ArrayUtils.shiftRight(this.indices, internalIndex, this.size);
            this.indices[internalIndex] = index;
            ++this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        ArrayList<String> elementStrings = new ArrayList<String>(this.size);
        for (int i = 0; i < this.size; ++i) {
            elementStrings.add(String.format("[%d]=%s", this.indices[i], this.elements[i]));
        }
        return String.format("{%s}", String.join((CharSequence)", ", elementStrings));
    }

    public void trimToSize() {
        if (this.elements.length < this.size) {
            this.elements = Arrays.copyOf(this.elements, this.size);
            this.indices = Arrays.copyOf(this.indices, this.size);
        }
    }
}

