/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.collection.concurrent;

import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.sellcom.core.Contract;

public class SimpleExpiringObject<T>
implements Comparable<SimpleExpiringObject<T>> {
    private Clock clock;
    private final long expiry;
    private final T value;

    public SimpleExpiringObject(T value, long expiry, TimeUnit unit) {
        this(value, expiry, unit, Clock.systemUTC());
    }

    SimpleExpiringObject(T value, long expiry, TimeUnit unit, Clock clock) {
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        Contract.checkArgument(expiry >= 0L, "Expiry must not be negative", new Object[0]);
        Contract.checkArgument(unit != null, "Unit must not be null", new Object[0]);
        this.value = value;
        this.expiry = Math.addExact(clock.millis(), unit.toMillis(expiry));
        this.clock = clock;
    }

    @Override
    public int compareTo(SimpleExpiringObject<T> other) {
        return Long.compare(this.expiry, other.expiry);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SimpleExpiringObject) {
            return Objects.equals(this.value, ((SimpleExpiringObject)other).value);
        }
        return false;
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean isExpired() {
        return this.clock.millis() > this.expiry;
    }

    void setClock(Clock clock) {
        Contract.checkArgument(clock != null, "Clock must not be null", new Object[0]);
        this.clock = clock;
    }
}

