/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;

public class Utf8ResourceBundle
extends PropertyResourceBundle {
    private static final String SUFFIX = "utf8";

    private Utf8ResourceBundle(Reader reader) throws IOException {
        super(reader);
    }

    public static Utf8ResourceBundle getUtf8Bundle(String baseName) {
        return Utf8ResourceBundle.getUtf8Bundle(baseName, Locale.getDefault());
    }

    public static Utf8ResourceBundle getUtf8Bundle(String baseName, Locale locale) {
        Contract.checkArgument(!Strings.isNullOrEmpty(baseName), "Base name must not be null or empty", new Object[0]);
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        return (Utf8ResourceBundle)Utf8ResourceBundle.getBundle(baseName, locale, new Control());
    }

    public static Utf8ResourceBundle getUtf8Bundle(String baseName, Locale locale, ClassLoader classLoader) {
        Contract.checkArgument(!Strings.isNullOrEmpty(baseName), "Base name must not be null or empty", new Object[0]);
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        Contract.checkArgument(classLoader != null, "Class loader must not be null", new Object[0]);
        return (Utf8ResourceBundle)Utf8ResourceBundle.getBundle(baseName, locale, new Control());
    }

    HashMap<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> keys = this.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, this.getString(key));
        }
        return map;
    }

    private static class Control
    extends ResourceBundle.Control {
        private Control() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            return Collections.unmodifiableList(Arrays.asList(Utf8ResourceBundle.SUFFIX));
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reload) throws IOException {
            String resourceName = this.toResourceName(this.toBundleName(baseName, locale), Utf8ResourceBundle.SUFFIX);
            InputStream sourceInputStream = classLoader.getResourceAsStream(resourceName);
            if (sourceInputStream == null) {
                return null;
            }
            try (InputStreamReader sourceReader = new InputStreamReader(sourceInputStream, StandardCharsets.UTF_8);){
                Utf8ResourceBundle utf8ResourceBundle = new Utf8ResourceBundle(sourceReader);
                return utf8ResourceBundle;
            }
        }
    }
}

