/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.collection.concurrent;

import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.sellcom.core.Contract;

public abstract class SimpleDelayed<T>
implements Delayed {
    private static Clock clock = Clock.systemUTC();
    private final long timestamp;
    private final T value;

    protected SimpleDelayed(T value, long delay, TimeUnit unit) {
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        Contract.checkArgument(delay >= 0L, "Delay must not be negative", new Object[0]);
        Contract.checkArgument(unit != null, "Unit must not be null", new Object[0]);
        this.timestamp = Math.addExact(clock.millis(), unit.toMillis(delay));
        this.value = value;
    }

    @Override
    public int compareTo(Delayed other) {
        if (other instanceof SimpleDelayed) {
            return Long.compare(this.timestamp, ((SimpleDelayed)other).timestamp);
        }
        return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), other.getDelay(TimeUnit.MILLISECONDS));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SimpleDelayed) {
            return Objects.equals(this.value, ((SimpleDelayed)other).value);
        }
        return false;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        Contract.checkArgument(unit != null, "Unit must not be null", new Object[0]);
        return unit.convert(Math.subtractExact(this.timestamp, clock.millis()), TimeUnit.MILLISECONDS);
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

