/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.io.encoding;

import java.math.BigInteger;
import java.util.Arrays;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.io.encoding.BinaryCodingException;
import org.sellcom.core.io.encoding.BinaryDecoder;
import org.sellcom.core.io.encoding.BinaryEncoder;
import org.sellcom.core.io.encoding.BinaryEncoding;
import org.sellcom.core.util.MoreArrays;

public abstract class ArbitraryBaseBinaryEncoding
extends BinaryEncoding {
    private final BigInteger BASE;
    private int[] DECODE_TABLE;
    private final char[] ENCODE_TABLE;

    protected ArbitraryBaseBinaryEncoding(char[] alphabet) {
        Contract.checkArgument(alphabet != null, "Alphabet must not be null", new Object[0]);
        this.BASE = BigInteger.valueOf(alphabet.length);
        this.ENCODE_TABLE = alphabet;
        this.DECODE_TABLE = ArbitraryBaseBinaryEncoding.createDecodeTable(alphabet);
    }

    @Override
    public BinaryDecoder newDecoder() {
        return new Decoder();
    }

    @Override
    public BinaryEncoder newEncoder() {
        return new Encoder();
    }

    private static int[] createDecodeTable(char[] encodeTable) {
        int[] decodeTable = new int[128];
        Arrays.fill(decodeTable, -1);
        int j = encodeTable.length;
        for (int i = 0; i < j; ++i) {
            decodeTable[encodeTable[i]] = i;
        }
        return decodeTable;
    }

    private class Encoder
    extends BinaryEncoder {
        private Encoder() {
        }

        @Override
        public String encodeToString(byte[] input) {
            int leadingZeros;
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            for (leadingZeros = 0; leadingZeros < input.length && input[leadingZeros] == 0; ++leadingZeros) {
            }
            StringBuilder builder = new StringBuilder();
            if (input.length > 0) {
                BigInteger value = new BigInteger(1, input);
                while (value.compareTo(BigInteger.ZERO) > 0) {
                    BigInteger[] tmp = value.divideAndRemainder(ArbitraryBaseBinaryEncoding.this.BASE);
                    builder.append(ArbitraryBaseBinaryEncoding.this.ENCODE_TABLE[tmp[1].intValue()]);
                    value = tmp[0];
                }
            }
            while (--leadingZeros >= 0) {
                builder.append(ArbitraryBaseBinaryEncoding.this.ENCODE_TABLE[0]);
            }
            return builder.reverse().toString();
        }
    }

    private class Decoder
    extends BinaryDecoder {
        private Decoder() {
        }

        @Override
        public byte[] decode(String input) {
            int outputLeadingZeros;
            int inputLeadingZeros;
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            if (Strings.isNullOrEmpty(input)) {
                return new byte[0];
            }
            for (inputLeadingZeros = 0; inputLeadingZeros < input.length() && input.charAt(inputLeadingZeros) == ArbitraryBaseBinaryEncoding.this.ENCODE_TABLE[0]; ++inputLeadingZeros) {
            }
            BigInteger value = BigInteger.ZERO;
            int j = input.length();
            for (int i = 0; i < j; ++i) {
                int addend;
                char currentChar = input.charAt(i);
                int n = addend = currentChar < '\u0080' ? ArbitraryBaseBinaryEncoding.this.DECODE_TABLE[currentChar] : -1;
                if (addend == -1) {
                    throw new BinaryCodingException(String.format("Illegal byte at position %d: 0x%02X", i, (int)currentChar));
                }
                value = value.multiply(ArbitraryBaseBinaryEncoding.this.BASE);
                value = value.add(BigInteger.valueOf(addend));
            }
            byte[] output = value.toByteArray();
            for (outputLeadingZeros = 0; outputLeadingZeros < output.length && output[outputLeadingZeros] == 0; ++outputLeadingZeros) {
            }
            if (outputLeadingZeros >= inputLeadingZeros) {
                return Arrays.copyOfRange(output, outputLeadingZeros - inputLeadingZeros, output.length);
            }
            return MoreArrays.concat(new byte[inputLeadingZeros - outputLeadingZeros], output);
        }
    }
}

