/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.io.encoding;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.sellcom.core.Contract;
import org.sellcom.core.io.encoding.BinaryDecoder;
import org.sellcom.core.io.encoding.BinaryEncoder;
import org.sellcom.core.io.encoding.BinaryEncoding;

public final class Base64UrlEncoding
extends BinaryEncoding {
    @Override
    public BinaryDecoder newDecoder() {
        return new Decoder();
    }

    @Override
    public BinaryEncoder newEncoder() {
        return new Encoder();
    }

    private static class Encoder
    extends BinaryEncoder {
        private final Base64.Encoder encoder = Base64.getUrlEncoder();

        private Encoder() {
        }

        @Override
        public byte[] encode(byte[] input) {
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            return this.encoder.encode(input);
        }

        @Override
        public ByteBuffer encode(ByteBuffer input) {
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            return this.encoder.encode(input);
        }

        @Override
        public String encodeToString(byte[] input) {
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            return this.encoder.encodeToString(input);
        }

        @Override
        public boolean supportsStreaming() {
            return true;
        }

        @Override
        public OutputStream wrap(OutputStream destination) {
            Contract.checkArgument(destination != null, "Destination stream must not be null", new Object[0]);
            return this.encoder.wrap(destination);
        }
    }

    private static class Decoder
    extends BinaryDecoder {
        private final Base64.Decoder decoder = Base64.getUrlDecoder();

        private Decoder() {
        }

        @Override
        public byte[] decode(byte[] input) {
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            return this.decoder.decode(input);
        }

        @Override
        public ByteBuffer decode(ByteBuffer input) {
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            return this.decoder.decode(input);
        }

        @Override
        public byte[] decode(String input) {
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            return this.decoder.decode(input);
        }

        @Override
        public boolean supportsStreaming() {
            return true;
        }

        @Override
        public InputStream wrap(InputStream source) {
            Contract.checkArgument(source != null, "Source stream must not be null", new Object[0]);
            return this.decoder.wrap(source);
        }
    }
}

