/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.io.type;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import org.sellcom.core.Strings;
import org.sellcom.core.io.MorePaths;

public class ContentTypeDetector
extends FileTypeDetector {
    @Override
    public String probeContentType(Path path) throws IOException {
        String normalizedExtension;
        switch (normalizedExtension = Strings.toLowerCase(MorePaths.getFileExtension(path))) {
            case "css": {
                return "text/css";
            }
            case "csv": {
                return "text/csv";
            }
            case "flac": {
                return "audio/flac";
            }
            case "htm": {
                return "text/html";
            }
            case "html": {
                return "text/html";
            }
            case "jpeg": {
                return "image/jpeg";
            }
            case "jpg": {
                return "image/jpeg";
            }
            case "js": {
                return "application/javascript";
            }
            case "json": {
                return "application/json";
            }
            case "m4a": {
                return "audio/mp4";
            }
            case "mp4": {
                return "video/mp4";
            }
            case "pdf": {
                return "application/pdf";
            }
            case "png": {
                return "image/png";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "txt": {
                return "text/plain";
            }
            case "vcard": {
                return "text/vcard";
            }
            case "vcf": {
                return "text/vcard";
            }
            case "webm": {
                return "video/webm";
            }
            case "webp": {
                return "image/webp";
            }
            case "xml": {
                return "text/xml";
            }
            case "zip": {
                return "application/zip";
            }
        }
        return "application/octet-stream";
    }
}

