/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.util;

import java.util.concurrent.ThreadLocalRandom;

public class RandomGenerator {
    private RandomGenerator() {
    }

    public static byte nextByte() {
        return (byte)RandomGenerator.nextInt(-128, 127);
    }

    public static byte nextByte(byte from, byte to) {
        return (byte)RandomGenerator.nextInt(from, to);
    }

    public static byte[] nextBytes(int count) {
        byte[] bytes = new byte[count];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }

    public static byte nextNegativeByte() {
        return (byte)RandomGenerator.nextInt(-128, 0);
    }

    public static byte nextPositiveByte() {
        return (byte)(RandomGenerator.nextInt(0, 127) + 1);
    }

    public static int nextInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static int nextInt(int from, int to) {
        return ThreadLocalRandom.current().nextInt(from, to);
    }

    public static int nextNegativeInt() {
        return RandomGenerator.nextInt(Integer.MIN_VALUE, 0);
    }

    public static int nextPositiveInt() {
        return RandomGenerator.nextInt(0, Integer.MAX_VALUE) + 1;
    }

    public static long nextLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static long nextLong(long from, long to) {
        return ThreadLocalRandom.current().nextLong(from, to);
    }

    public static long nextNegativeLong() {
        return RandomGenerator.nextLong(Long.MIN_VALUE, 0L);
    }

    public static long nextPositiveLong() {
        return RandomGenerator.nextLong(0L, Long.MAX_VALUE) + 1L;
    }

    public static short nextShort() {
        return (short)RandomGenerator.nextInt(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short nextShort(short from, short to) {
        return (short)RandomGenerator.nextInt(from, to);
    }

    public static String nextString(String alphabet, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(alphabet.charAt(RandomGenerator.nextInt(0, alphabet.length())));
        }
        return builder.toString();
    }

    public static short nextNegativeShort() {
        return (short)RandomGenerator.nextInt(Short.MIN_VALUE, 0);
    }

    public static short nextPositiveShort() {
        return (short)(RandomGenerator.nextInt(0, Short.MAX_VALUE) + 1);
    }
}

