/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.io.Io;
import org.sellcom.core.io.encoding.TtlvBuilder;
import org.sellcom.core.io.encoding.TtlvExtractor;

public class Ttlv {
    private Ttlv() {
    }

    public static TtlvBuilder create() {
        return new Builder();
    }

    public static TtlvExtractor parse(byte[] message) throws IOException {
        Contract.checkArgument(message != null, "Message must not be null", new Object[0]);
        return Ttlv.parse(new ByteArrayInputStream(message));
    }

    public static TtlvExtractor parse(byte[] message, int offset, int length) throws IOException {
        Contract.checkArgument(message != null, "Message must not be null", new Object[0]);
        return Ttlv.parse(new ByteArrayInputStream(message, offset, length));
    }

    private static TtlvExtractor parse(ByteArrayInputStream source) throws IOException {
        Extractor extractor = new Extractor();
        while (source.available() > 0) {
            short tag = Io.readShort(source);
            Type type = Type.fromValue(Io.readByte(source));
            int length = Io.readInt(source);
            if (length > 0) {
                extractor.entries.put(tag, type.read(source, length));
                continue;
            }
            extractor.entries.put(tag, null);
        }
        return extractor;
    }

    private static class TypedValue {
        private final Type type;
        private final Object value;

        TypedValue(Type type, Object value) {
            this.type = type;
            this.value = value;
        }

        void write(OutputStream destination) throws IOException {
            this.type.write(destination, this.value);
        }
    }

    private static enum Type {
        BLOB(1){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Io.readBytes(source, length);
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                byte[] value = (byte[])genericValue;
                Io.writeByte(destination, this.value);
                if (value == null) {
                    Io.writeInt(destination, 0);
                } else {
                    Io.writeInt(destination, value.length);
                    Io.writeBytes(destination, value);
                }
            }
        }
        ,
        BOOLEAN(8){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Boolean.valueOf(Io.readByte(source) != 0);
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                Boolean value = (Boolean)genericValue;
                Io.writeByte(destination, this.value);
                if (value == null) {
                    Io.writeInt(destination, 0);
                } else {
                    Io.writeInt(destination, 1);
                    Io.writeByte(destination, value != false ? (byte)1 : 0);
                }
            }
        }
        ,
        BYTE(2){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Byte.valueOf(Io.readByte(source));
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                Byte value = (Byte)genericValue;
                Io.writeByte(destination, this.value);
                if (value == null) {
                    Io.writeInt(destination, 0);
                } else {
                    Io.writeInt(destination, 1);
                    Io.writeByte(destination, value);
                }
            }
        }
        ,
        CHARACTER(9){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Character.valueOf(Io.readChar(source));
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                Character value = (Character)genericValue;
                Io.writeByte(destination, this.value);
                if (value == null) {
                    Io.writeInt(destination, 0);
                } else {
                    Io.writeInt(destination, 2);
                    Io.writeChar(destination, value.charValue());
                }
            }
        }
        ,
        DOUBLE(7){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Double.valueOf(Io.readDouble(source));
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                Double value = (Double)genericValue;
                Io.writeByte(destination, this.value);
                if (value == null) {
                    Io.writeInt(destination, 0);
                } else {
                    Io.writeInt(destination, 8);
                    Io.writeDouble(destination, value);
                }
            }
        }
        ,
        FLOAT(6){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Float.valueOf(Io.readFloat(source));
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                Float value = (Float)genericValue;
                Io.writeByte(destination, this.value);
                if (value == null) {
                    Io.writeInt(destination, 0);
                } else {
                    Io.writeInt(destination, 4);
                    Io.writeFloat(destination, value.floatValue());
                }
            }
        }
        ,
        INTEGER(4){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Integer.valueOf(Io.readInt(source));
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                Integer value = (Integer)genericValue;
                Io.writeByte(destination, this.value);
                if (value == null) {
                    Io.writeInt(destination, 0);
                } else {
                    Io.writeInt(destination, 4);
                    Io.writeInt(destination, value);
                }
            }
        }
        ,
        LONG(5){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Long.valueOf(Io.readLong(source));
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                Long value = (Long)genericValue;
                Io.writeByte(destination, this.value);
                if (value == null) {
                    Io.writeInt(destination, 0);
                } else {
                    Io.writeInt(destination, 8);
                    Io.writeLong(destination, value);
                }
            }
        }
        ,
        SHORT(3){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Short.valueOf(Io.readShort(source));
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                Short value = (Short)genericValue;
                Io.writeByte(destination, this.value);
                if (value == null) {
                    Io.writeInt(destination, 0);
                } else {
                    Io.writeInt(destination, 2);
                    Io.writeShort(destination, value);
                }
            }
        }
        ,
        STRING_UTF_8(10){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Io.readString(source, length, StandardCharsets.UTF_8);
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                byte[] value = Strings.nullToEmpty((String)genericValue).getBytes(StandardCharsets.UTF_8);
                Io.writeByte(destination, this.value);
                Io.writeInt(destination, value.length);
                Io.writeBytes(destination, value);
            }
        }
        ,
        STRING_UTF_16BE(11){

            @Override
            Object read(InputStream source, int length) throws IOException {
                return length == 0 ? null : Io.readString(source, length, StandardCharsets.UTF_16BE);
            }

            @Override
            void write(OutputStream destination, Object genericValue) throws IOException {
                byte[] value = Strings.nullToEmpty((String)genericValue).getBytes(StandardCharsets.UTF_8);
                Io.writeByte(destination, this.value);
                Io.writeInt(destination, value.length);
                Io.writeBytes(destination, value);
            }
        };

        private static final Map<Byte, Type> LOOKUP_TABLE;
        protected byte value;

        private Type(byte value) {
            this.value = value;
        }

        static Type fromValue(byte value) {
            return LOOKUP_TABLE.get(value);
        }

        abstract Object read(InputStream var1, int var2) throws IOException;

        abstract void write(OutputStream var1, Object var2) throws IOException;

        static {
            LOOKUP_TABLE = new HashMap<Byte, Type>();
            EnumSet.allOf(Type.class).stream().forEach(type -> LOOKUP_TABLE.put(type.value, (Type)((Object)type)));
        }
    }

    private static class Extractor
    implements TtlvExtractor {
        private final Map<Short, Object> entries = new LinkedHashMap<Short, Object>();

        private Extractor() {
        }

        @Override
        public byte[] getBlob(short tag) {
            return (byte[])this.entries.get(tag);
        }

        @Override
        public Boolean getBoolean(short tag) {
            return (Boolean)this.entries.get(tag);
        }

        @Override
        public Byte getByte(short tag) {
            return (Byte)this.entries.get(tag);
        }

        @Override
        public Character getCharacter(short tag) {
            return (Character)this.entries.get(tag);
        }

        @Override
        public Double getDouble(short tag) {
            return (Double)this.entries.get(tag);
        }

        @Override
        public Float getFloat(short tag) {
            return (Float)this.entries.get(tag);
        }

        @Override
        public Integer getInteger(short tag) {
            return (Integer)this.entries.get(tag);
        }

        @Override
        public Long getLong(short tag) {
            return (Long)this.entries.get(tag);
        }

        @Override
        public Short getShort(short tag) {
            return (Short)this.entries.get(tag);
        }

        @Override
        public String getString(short tag) {
            return (String)this.entries.get(tag);
        }
    }

    private static class Builder
    implements TtlvBuilder {
        private final Map<Short, TypedValue> entries = new LinkedHashMap<Short, TypedValue>();

        private Builder() {
        }

        @Override
        public byte[] build() {
            try {
                ByteArrayOutputStream target = new ByteArrayOutputStream();
                for (Map.Entry<Short, TypedValue> entry : this.entries.entrySet()) {
                    Io.writeShort(target, entry.getKey());
                    entry.getValue().write(target);
                }
                return target.toByteArray();
            }
            catch (IOException e) {
                throw new AssertionError((Object)"ByteArrayOutputStream threw IOException");
            }
        }

        @Override
        public TtlvBuilder putBlob(short tag, byte[] value) {
            this.entries.put(tag, new TypedValue(Type.BLOB, value));
            return this;
        }

        @Override
        public TtlvBuilder putBoolean(short tag, Boolean value) {
            this.entries.put(tag, new TypedValue(Type.BOOLEAN, value));
            return this;
        }

        @Override
        public TtlvBuilder putByte(short tag, Byte value) {
            this.entries.put(tag, new TypedValue(Type.BYTE, value));
            return this;
        }

        @Override
        public TtlvBuilder putCharacter(short tag, Character value) {
            this.entries.put(tag, new TypedValue(Type.CHARACTER, value));
            return this;
        }

        @Override
        public TtlvBuilder putDouble(short tag, Double value) {
            this.entries.put(tag, new TypedValue(Type.DOUBLE, value));
            return this;
        }

        @Override
        public TtlvBuilder putFloat(short tag, Float value) {
            this.entries.put(tag, new TypedValue(Type.FLOAT, value));
            return this;
        }

        @Override
        public TtlvBuilder putInteger(short tag, Integer value) {
            this.entries.put(tag, new TypedValue(Type.INTEGER, value));
            return this;
        }

        @Override
        public TtlvBuilder putLong(short tag, Long value) {
            this.entries.put(tag, new TypedValue(Type.LONG, value));
            return this;
        }

        @Override
        public TtlvBuilder putShort(short tag, Short value) {
            this.entries.put(tag, new TypedValue(Type.SHORT, value));
            return this;
        }

        @Override
        public TtlvBuilder putUtf8String(short tag, String value) {
            this.entries.put(tag, new TypedValue(Type.STRING_UTF_8, value));
            return this;
        }

        @Override
        public TtlvBuilder putUtf16String(short tag, String value) {
            this.entries.put(tag, new TypedValue(Type.STRING_UTF_16BE, value));
            return this;
        }
    }
}

