/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.sellcom.core.Contract;

public class MoreMath {
    private MoreMath() {
    }

    public static BigDecimal absDifference(BigDecimal x, BigDecimal y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        return MoreMath.absExact(MoreMath.subtractExact(x, y));
    }

    public static BigInteger absDifference(BigInteger x, BigInteger y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        return MoreMath.absExact(MoreMath.subtractExact(x, y));
    }

    public static double absDifference(double x, double y) {
        Contract.checkArgument(Double.isFinite(x), "X must be finite: {0}", x);
        Contract.checkArgument(Double.isFinite(y), "Y must be finite: {0}", y);
        return Math.abs(x - y);
    }

    public static float absDifference(float x, float y) {
        Contract.checkArgument(Float.isFinite(x), "X must be finite: {0}", Float.valueOf(x));
        Contract.checkArgument(Float.isFinite(y), "Y must be finite: {0}", Float.valueOf(y));
        return Math.abs(x - y);
    }

    public static int absDifference(int x, int y) {
        return MoreMath.absExact(MoreMath.subtractExact(x, y));
    }

    public static long absDifference(long x, long y) {
        return MoreMath.absExact(MoreMath.subtractExact(x, y));
    }

    public static BigDecimal absExact(BigDecimal x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.abs();
    }

    public static BigInteger absExact(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.abs();
    }

    public static double absExact(double x) {
        Contract.checkArgument(!Double.isNaN(x), "X must not be NaN", new Object[0]);
        return Math.abs(x);
    }

    public static float absExact(float x) {
        Contract.checkArgument(!Float.isNaN(x), "X must not be NaN", new Object[0]);
        return Math.abs(x);
    }

    public static int absExact(int x) {
        Contract.check(x != Integer.MIN_VALUE, ArithmeticException.class, "Integer overflow", new Object[0]);
        return Math.abs(x);
    }

    public static long absExact(long x) {
        Contract.check(x != Long.MIN_VALUE, ArithmeticException.class, "Integer overflow", new Object[0]);
        return Math.abs(x);
    }

    public static BigDecimal addExact(BigDecimal x, BigDecimal y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        return x.add(y);
    }

    public static BigInteger addExact(BigInteger x, BigInteger y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        return x.add(y);
    }

    public static int addExact(int x, int y) {
        int result = x + y;
        if (((x ^ result) & (y ^ result)) < 0) {
            throw new ArithmeticException("Integer overflow");
        }
        return result;
    }

    public static long addExact(long x, long y) {
        long result = x + y;
        if (((x ^ result) & (y ^ result)) < 0L) {
            throw new ArithmeticException("Integer overflow");
        }
        return result;
    }

    public static BigInteger decrementExact(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.subtract(BigInteger.ONE);
    }

    public static int decrementExact(int x) {
        Contract.check(x != Integer.MIN_VALUE, ArithmeticException.class, "Integer overflow", new Object[0]);
        return x - 1;
    }

    public static long decrementExact(long x) {
        Contract.check(x != Long.MIN_VALUE, ArithmeticException.class, "Integer overflow", new Object[0]);
        return x - 1L;
    }

    public static boolean equals(double x, double y, double tolerance) {
        Contract.checkArgument(Double.isFinite(tolerance), "Tolerance must be finite: {0}", tolerance);
        Contract.checkArgument(tolerance >= 0.0, "Tolerance must not be negative: {0}", tolerance);
        return MoreMath.absDifference(x, y) <= tolerance;
    }

    public static boolean equals(float x, float y, float tolerance) {
        Contract.checkArgument(Float.isFinite(tolerance), "Tolerance must be finite: {0}", Float.valueOf(tolerance));
        Contract.checkArgument(tolerance >= 0.0f, "Tolerance must not be negative: {0}", Float.valueOf(tolerance));
        return MoreMath.absDifference(x, y) <= tolerance;
    }

    public static BigDecimal fractionalPart(BigDecimal x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.remainder(BigDecimal.ONE);
    }

    public static double fractionalPart(double x) {
        Contract.checkArgument(Double.isFinite(x), "X must be finite: {0}", x);
        return x % 1.0;
    }

    public static float fractionalPart(float x) {
        Contract.checkArgument(Float.isFinite(x), "X must be finite: {0}", Float.valueOf(x));
        return x % 1.0f;
    }

    public static BigInteger gcd(BigInteger x, BigInteger y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        return x.gcd(y);
    }

    public static int gcd(int x, int y) {
        if (x < 0) {
            x = MoreMath.absExact(x);
        }
        if (y < 0) {
            y = MoreMath.absExact(y);
        }
        if (x == 0) {
            return y;
        }
        if (y == 0) {
            return x;
        }
        if (x == y) {
            return y;
        }
        int shift = 0;
        while (((x | y) & 1) == 0) {
            x >>= 1;
            y >>= 1;
            ++shift;
        }
        while ((x & 1) == 0) {
            x >>= 1;
        }
        while (true) {
            if ((y & 1) == 0) {
                y >>= 1;
                continue;
            }
            if (x > y) {
                int tmp = x;
                x = y;
                y = tmp;
            }
            if ((y = MoreMath.subtractExact(y, x)) == 0) break;
        }
        return x << shift;
    }

    public static long gcd(long x, long y) {
        if (x < 0L) {
            x = MoreMath.absExact(x);
        }
        if (y < 0L) {
            y = MoreMath.absExact(y);
        }
        if (x == 0L) {
            return y;
        }
        if (y == 0L) {
            return x;
        }
        if (x == y) {
            return y;
        }
        int shift = 0;
        while (((x | y) & 1L) == 0L) {
            x >>= 1;
            y >>= 1;
            ++shift;
        }
        while ((x & 1L) == 0L) {
            x >>= 1;
        }
        while (true) {
            if ((y & 1L) == 0L) {
                y >>= 1;
                continue;
            }
            if (x > y) {
                long tmp = x;
                x = y;
                y = tmp;
            }
            if ((y = MoreMath.subtractExact(y, x)) == 0L) break;
        }
        return x << shift;
    }

    public static BigInteger incrementExact(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.add(BigInteger.ONE);
    }

    public static int incrementExact(int x) {
        Contract.check(x != Integer.MAX_VALUE, ArithmeticException.class, "Integer overflow", new Object[0]);
        return x + 1;
    }

    public static long incrementExact(long x) {
        Contract.check(x != Long.MAX_VALUE, ArithmeticException.class, "Integer overflow", new Object[0]);
        return x + 1L;
    }

    public static boolean isEven(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.getLowestSetBit() != 0;
    }

    public static boolean isEven(int x) {
        return (x & 1) == 0;
    }

    public static boolean isEven(long x) {
        return (x & 1L) == 0L;
    }

    public static boolean isOdd(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.getLowestSetBit() == 1;
    }

    public static boolean isOdd(int x) {
        return (x & 1) != 0;
    }

    public static boolean isOdd(long x) {
        return (x & 1L) != 0L;
    }

    public static BigInteger lcm(BigInteger x, BigInteger y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        if (x.equals(BigInteger.ZERO) && y.equals(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        return MoreMath.absExact(x).divide(MoreMath.gcd(x, y)).multiply(MoreMath.absExact(y));
    }

    public static int lcm(int x, int y) {
        if (x == 0 && y == 0) {
            return 0;
        }
        return MoreMath.multiplyExact(MoreMath.absExact(x) / MoreMath.gcd(x, y), MoreMath.absExact(y));
    }

    public static long lcm(long x, long y) {
        if (x == 0L && y == 0L) {
            return 0L;
        }
        return MoreMath.multiplyExact(MoreMath.absExact(x) / MoreMath.gcd(x, y), MoreMath.absExact(y));
    }

    public static double ld(double x) {
        Contract.checkArgument(Double.isFinite(x), "X must be finite: {0}", x);
        return Math.log(x) / Math.log(2.0);
    }

    public static double ln(double x) {
        Contract.checkArgument(Double.isFinite(x), "X must be finite: {0}", x);
        return Math.log(x);
    }

    public static BigDecimal multiplyExact(BigDecimal x, BigDecimal y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        return x.multiply(y);
    }

    public static BigInteger multiplyExact(BigInteger x, BigInteger y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        return x.multiply(y);
    }

    public static int multiplyExact(int x, int y) {
        return MoreMath.toIntExact((long)x * (long)y);
    }

    public static long multiplyExact(long x, long y) {
        long result = x * y;
        if ((Math.abs(x) | Math.abs(y)) >>> 31 != 0L && (y != 0L && result / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw new ArithmeticException("Integer overflow");
        }
        return result;
    }

    public static BigDecimal negateExact(BigDecimal x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.negate();
    }

    public static BigInteger negateExact(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.negate();
    }

    public static double negateExact(double x) {
        Contract.checkArgument(!Double.isNaN(x), "X must not be NaN", new Object[0]);
        return -x;
    }

    public static float negateExact(float x) {
        Contract.checkArgument(!Float.isNaN(x), "X must not be NaN", new Object[0]);
        return -x;
    }

    public static int negateExact(int x) {
        Contract.check(x != Integer.MIN_VALUE, ArithmeticException.class, "Integer overflow", new Object[0]);
        return -x;
    }

    public static long negateExact(long x) {
        Contract.check(x != Long.MIN_VALUE, ArithmeticException.class, "Integer overflow", new Object[0]);
        return -x;
    }

    public static int signum(BigDecimal x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.signum();
    }

    public static int signum(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.signum();
    }

    public static int signum(double x) {
        Contract.checkArgument(!Double.isNaN(x), "X must not be NaN", new Object[0]);
        return MoreMath.toIntExact(Math.signum(x));
    }

    public static int signum(float x) {
        Contract.checkArgument(!Float.isNaN(x), "X must not be NaN", new Object[0]);
        return MoreMath.toIntExact(Math.signum(x));
    }

    public static int signum(int x) {
        return Integer.signum(x);
    }

    public static int signum(long x) {
        return Long.signum(x);
    }

    public static BigDecimal subtractExact(BigDecimal x, BigDecimal y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        return x.subtract(y);
    }

    public static BigInteger subtractExact(BigInteger x, BigInteger y) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(y != null, "Y must not be null", new Object[0]);
        return x.subtract(y);
    }

    public static int subtractExact(int x, int y) {
        int result = x - y;
        if (((x ^ y) & (x ^ result)) < 0) {
            throw new ArithmeticException("Integer overflow");
        }
        return result;
    }

    public static long subtractExact(long x, long y) {
        long result = x - y;
        if (((x ^ y) & (x ^ result)) < 0L) {
            throw new ArithmeticException("Integer overflow");
        }
        return result;
    }

    public static BigInteger toBigIntegerExact(BigDecimal x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.toBigIntegerExact();
    }

    public static int toIntExact(BigDecimal x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.intValueExact();
    }

    public static int toIntExact(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.intValueExact();
    }

    public static int toIntExact(double x) {
        Contract.check(MoreMath.fractionalPart(x) == 0.0, ArithmeticException.class, "Not an integer", new Object[0]);
        Contract.check((double)((int)x) == x, ArithmeticException.class, "Integer overflow", new Object[0]);
        return (int)x;
    }

    public static int toIntExact(float x) {
        Contract.check(MoreMath.fractionalPart(x) == 0.0f, ArithmeticException.class, "Not an integer", new Object[0]);
        Contract.check((float)((int)x) == x, ArithmeticException.class, "Integer overflow", new Object[0]);
        return (int)x;
    }

    public static int toIntExact(long x) {
        Contract.check((long)((int)x) == x, ArithmeticException.class, "Integer overflow", new Object[0]);
        return (int)x;
    }

    public static long toLongExact(BigDecimal x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.longValueExact();
    }

    public static long toLongExact(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.longValueExact();
    }

    public static long toLongExact(double x) {
        Contract.check(MoreMath.fractionalPart(x) == 0.0, ArithmeticException.class, "Not an integer", new Object[0]);
        Contract.check((double)((int)x) == x, ArithmeticException.class, "Integer overflow", new Object[0]);
        return (long)x;
    }

    public static long toLongExact(float x) {
        Contract.check(MoreMath.fractionalPart(x) == 0.0f, ArithmeticException.class, "Not an integer", new Object[0]);
        Contract.check((float)((int)x) == x, ArithmeticException.class, "Integer overflow", new Object[0]);
        return (long)x;
    }

    public static short toShortExact(BigDecimal x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.shortValueExact();
    }

    public static short toShortExact(BigInteger x) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        return x.shortValueExact();
    }

    public static short toShortExact(double x) {
        Contract.check(MoreMath.fractionalPart(x) == 0.0, ArithmeticException.class, "Not an integer", new Object[0]);
        Contract.check((double)((int)x) == x, ArithmeticException.class, "Integer overflow", new Object[0]);
        return (short)x;
    }

    public static short toShortExact(float x) {
        Contract.check(MoreMath.fractionalPart(x) == 0.0f, ArithmeticException.class, "Not an integer", new Object[0]);
        Contract.check((float)((int)x) == x, ArithmeticException.class, "Integer overflow", new Object[0]);
        return (short)x;
    }

    public static short toShortExact(int x) {
        Contract.check((short)x == x, ArithmeticException.class, "Integer overflow", new Object[0]);
        return (short)x;
    }

    public static short toShortExact(long x) {
        Contract.check((long)((short)x) == x, ArithmeticException.class, "Integer overflow", new Object[0]);
        return (short)x;
    }
}

